/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.falcon.sdk.customer.signup.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ehking.falcon.sdk.customer.signup.builder.SignUpQueryBuilder;
import com.ehking.falcon.sdk.exception.ResponseException;
import com.ehking.falcon.sdk.exception.UnknownException;
import com.ehking.falcon.sdk.executer.Executer;
import com.ehking.falcon.sdk.executer.ResultListener;
import com.ehking.falcon.sdk.util.CipherWrapper;
import com.ehking.falcon.sdk.util.ConfigurationUtils;
import com.ehking.falcon.sdk.util.Constants;
import com.ehking.falcon.sdk.util.HttpClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUpQueryExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(SignUpQueryExecuter.class);

    public void bothOrder(SignUpQueryBuilder builder, ResultListener resultListener) {
        block5: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getSignUpQueryUrl(), requestData);
                LOGGER.info("responseStr :{}", (Object)responseStr);
                JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.debug("responseStr:[" + responseData + "]");
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                    resultListener.success(responseData);
                    break block5;
                }
                if (Constants.FAILED.equals(responseData.getString(Constants.STATUS))) {
                    resultListener.failure(responseData);
                    break block5;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("request order exception", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }
}

