/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.falcon.sdk.tls.support_1_6;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.LinkedList;
import org.bouncycastle.by_1_52.crypto.tls.CertificateRequest;
import org.bouncycastle.by_1_52.crypto.tls.TlsAuthentication;
import org.bouncycastle.by_1_52.crypto.tls.TlsCredentials;

public class TLSAuthentication
implements TlsAuthentication {
    private Certificate[] peertCerts;

    public Certificate[] getPeertCerts() {
        return this.peertCerts;
    }

    @Override
    public void notifyServerCertificate(org.bouncycastle.by_1_52.crypto.tls.Certificate serverCertificate) throws IOException {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            LinkedList<Certificate> certs = new LinkedList<Certificate>();
            for (org.bouncycastle.by_1_52.asn1.x509.Certificate c : serverCertificate.getCertificateList()) {
                Certificate cert = cf.generateCertificate(new ByteArrayInputStream(c.getEncoded()));
                certs.add(cert);
            }
            this.peertCerts = certs.toArray(new Certificate[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException(ex);
        }
    }

    @Override
    public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) {
        return null;
    }

    private KeyStore _loadKeyStore() throws Exception {
        String trustStoreProvider;
        KeyStore localKeyStore = null;
        String trustStoreType = System.getProperty("javax.net.ssl.trustStoreType") != null ? System.getProperty("javax.net.ssl.trustStoreType") : KeyStore.getDefaultType();
        String string = trustStoreProvider = System.getProperty("javax.net.ssl.trustStoreProvider") != null ? System.getProperty("javax.net.ssl.trustStoreProvider") : "";
        if (trustStoreType.length() != 0) {
            String str5;
            localKeyStore = trustStoreProvider.length() == 0 ? KeyStore.getInstance(trustStoreType) : KeyStore.getInstance(trustStoreType, trustStoreProvider);
            char[] keyStorePass = null;
            String string2 = str5 = System.getProperty("javax.net.ssl.trustStorePassword") != null ? System.getProperty("javax.net.ssl.trustStorePassword") : "";
            if (str5.length() != 0) {
                keyStorePass = str5.toCharArray();
            }
            localKeyStore.load(null, keyStorePass);
        }
        return localKeyStore;
    }
}

