/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.falcon.sdk.tls.support_1_6;

import com.ehking.falcon.sdk.tls.support_1_6.TLSAuthentication;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.Socket;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.bouncycastle.by_1_52.crypto.tls.CipherSuite;
import org.bouncycastle.by_1_52.crypto.tls.DefaultTlsClient;
import org.bouncycastle.by_1_52.crypto.tls.TlsAuthentication;

public class TLSClient
extends DefaultTlsClient {
    private static final Map<Integer, String> CLIPHER_SUITES_MAP;
    private final String host;
    private final Socket socket;
    private final TLSAuthentication tlsAuthentication = new TLSAuthentication();

    public TLSClient(String host, Socket socket) {
        this.host = host;
        this.socket = socket;
    }

    public String getHost() {
        return this.host;
    }

    public Certificate[] getPeerCertificates() {
        return this.tlsAuthentication.getPeertCerts();
    }

    public String[] getCipherSuitesString() {
        int[] cipherSuites = this.getCipherSuites();
        ArrayList<String> list = new ArrayList<String>(cipherSuites.length);
        for (int i : cipherSuites) {
            list.add(CLIPHER_SUITES_MAP.get(i));
        }
        return list.toArray(new String[0]);
    }

    public int getSelectedCipherSuite() {
        return this.selectedCipherSuite;
    }

    public String getSelectedCipherSuiteStr() {
        return CLIPHER_SUITES_MAP.get(this.getSelectedCipherSuite());
    }

    @Override
    public Hashtable<Integer, byte[]> getClientExtensions() throws IOException {
        Hashtable<Integer, byte[]> clientExtensions = super.getClientExtensions();
        if (clientExtensions == null) {
            clientExtensions = new Hashtable<Integer, byte[]>();
        }
        byte[] host_name = this.host.getBytes("utf-8");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeShort(host_name.length + 3);
        dos.writeByte(0);
        dos.writeShort(host_name.length);
        dos.write(host_name);
        dos.close();
        clientExtensions.put(0, baos.toByteArray());
        return clientExtensions;
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        return this.tlsAuthentication;
    }

    static {
        Field[] fields;
        CLIPHER_SUITES_MAP = new HashMap<Integer, String>();
        for (Field field : fields = CipherSuite.class.getDeclaredFields()) {
            try {
                CLIPHER_SUITES_MAP.put(field.getInt(null), field.getName());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

