/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.falcon.sdk.util;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigurationUtils {
    static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationUtils.class);
    private static boolean customSource;
    private static final String PUBLIC = ".public";
    public static String CONFIG_FILE;

    private static String getString(String key) {
        String value = StringUtils.trim((String)Holder.config.getString(key));
        if (StringUtils.isBlank((CharSequence)value)) {
            LOGGER.warn("ConfigurationUtils.getString:[" + key + "] is blank");
        }
        return value;
    }

    private static Integer getInteger(String key, Integer defaultValue) {
        Integer value = Holder.config.getInteger(key, defaultValue);
        return value;
    }

    public static String getPublicKey(String merchantCode) {
        return ConfigurationUtils.getString(merchantCode + PUBLIC);
    }

    public static String getHmacKey(String merchantCode) {
        return ConfigurationUtils.getString(merchantCode);
    }

    public static String getPayOrderUrl() {
        return ConfigurationUtils.getString("pay.order.url");
    }

    public static String getMerchantPayOrderUrl() {
        return ConfigurationUtils.getString("merchant.pay.order.url");
    }

    public static String getPayOrderQueryUrl() {
        return ConfigurationUtils.getString("pay.order.query.url");
    }

    public static String getPayOrderDetailQueryUrl() {
        return ConfigurationUtils.getString("pay.order.detail.query.url");
    }

    public static String getMerchantPayOrderDetailQueryUrl() {
        return ConfigurationUtils.getString("pay.merchant.order.detail.query.url");
    }

    public static String getAccountQueryUrl() {
        return ConfigurationUtils.getString("account.query.url");
    }

    public static String getCreateInsuranceUrl() {
        return ConfigurationUtils.getString("insurance.create.url");
    }

    public static String getQueryInsuranceUrl() {
        return ConfigurationUtils.getString("insurance.query.url");
    }

    public static String getMerchantAccountQueryUrl() {
        return ConfigurationUtils.getString("account.merchant.query.url");
    }

    public static String getAccountSubrogateQueryUrl() {
        return ConfigurationUtils.getString("account.subrogate.query.url");
    }

    public static String getRechargeQueryUrl() {
        return ConfigurationUtils.getString("account.recharge.query.url");
    }

    public static String getOrderVoucherUrl() {
        return ConfigurationUtils.getString("order.voucher.url");
    }

    public static String getSignUpUrl() {
        return ConfigurationUtils.getString("signUp.order.url");
    }

    public static String getLivePhotoAuthUrl() {
        return ConfigurationUtils.getString("live.photo.auth.url");
    }

    public static String getLivePhotoAuthQueryUrl() {
        return ConfigurationUtils.getString("live.photo.auth.query.url");
    }

    public static String getSignUpQueryUrl() {
        return ConfigurationUtils.getString("signUp.query.url");
    }

    public static String getPayOrderInvoiceUrl() {
        return ConfigurationUtils.getString("pay.order.invoice.url");
    }

    public static String getPayOrderInvoiceQueryUrl() {
        return ConfigurationUtils.getString("pay.order.invoice.query.url");
    }

    public static String getInvoiceRecordQueryUrl() {
        return ConfigurationUtils.getString("pay.order.invoice.record.url");
    }

    public static Integer getConnectTimeout() {
        return ConfigurationUtils.getInteger("ehking.sdk.net.client.defaultConnectTimeout", null);
    }

    public static Integer getReadTimeout() {
        return ConfigurationUtils.getInteger("ehking.sdk.net.client.defaultReadTimeout", null);
    }

    public static String getHttpContentType() {
        return ConfigurationUtils.getString("http.content.type");
    }

    public static String getHttpContentTypeV2() {
        return ConfigurationUtils.getString("http.content.type.v2");
    }

    public static String getHttpContentTypeV3() {
        return ConfigurationUtils.getString("http.content.type.v3");
    }

    public static String getServerPublicKey() {
        return ConfigurationUtils.getString("server.public.key.path");
    }

    public static String getClientPrivateKeyPath(String merchantCode) {
        return ConfigurationUtils.getString(merchantCode + ".client.private.key.path");
    }

    public static String getClientPrivateKeyPassword(String merchantCode) {
        return ConfigurationUtils.getString(merchantCode + ".client.private.key.password");
    }

    public static void setProperty(String key, Object value) {
        Holder.config.setProperty(key, value);
    }

    public static void setConfigSource(Configuration configSource) {
        if (configSource == null) {
            throw new IllegalArgumentException("configSource is null");
        }
        customSource = true;
        Holder.config = configSource;
    }

    public static String getOldClientPrivateKeyPath(String merchantCode) {
        return ConfigurationUtils.getString(merchantCode + ".client.old.private.key.path");
    }

    public static String getOldClientPrivateKeyPassword(String merchantCode) {
        return ConfigurationUtils.getString(merchantCode + ".client.old.private.key.password");
    }

    static {
        CONFIG_FILE = "lw-config.properties";
    }

    private static class Holder {
        public static Configuration config;

        private Holder() {
        }

        static {
            try {
                if (!customSource) {
                    config = new PropertiesConfiguration(CONFIG_FILE);
                }
            }
            catch (ConfigurationException e) {
                LOGGER.error("classpath:lw-config.properties not found", (Throwable)e);
            }
        }
    }
}

