/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.falcon.sdk.util;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignPublisher {
    static final Logger LOGGER = LoggerFactory.getLogger(SignPublisher.class);
    private static HashSet<Class<?>> primitiveClasses = new HashSet();

    public static String generateHmacSource(Object obj) throws IllegalAccessException {
        if (obj == null) {
            throw new IllegalArgumentException("the obj is null");
        }
        StringBuilder hmacSource = new StringBuilder();
        SignPublisher.append(obj, hmacSource);
        LOGGER.debug("generateHmacSource hmacSource:{}", (Object)hmacSource.toString());
        return hmacSource.toString();
    }

    private static void sortField(Class<?> clazz, List<String> fields) {
        Class<?> parent = clazz.getSuperclass();
        if (parent != null) {
            SignPublisher.sortField(parent, fields);
        }
        for (Field field : clazz.getDeclaredFields()) {
            fields.add(field.getName());
        }
        Collections.sort(fields);
    }

    private static void append(Object entity, List<String> fields, StringBuilder hmacSource) throws IllegalAccessException {
        Class<?> clazz = entity.getClass();
        for (String fieldName : fields) {
            Field field;
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                field = SignPublisher.findParentField(entity, fieldName);
            }
            if (field == null || field.isSynthetic()) continue;
            field.setAccessible(true);
            Object obj = field.get(entity);
            Class<?> type = field.getType();
            Type superType = field.getGenericType();
            Class genericClass = null;
            if (superType instanceof ParameterizedType) {
                Type[] genericType = ((ParameterizedType)superType).getActualTypeArguments();
                genericClass = (Class)genericType[0];
            }
            if (type.isArray()) {
                Object[] objects = (Object[])obj;
                if (objects == null || objects.length <= 0) continue;
                for (Object object : objects) {
                    SignPublisher.append(object, hmacSource);
                }
                continue;
            }
            if (obj instanceof Collection) {
                Collection collection = (Collection)obj;
                for (Object next : collection) {
                    if (genericClass != null && SignPublisher.isPrimitiveClass(genericClass)) {
                        hmacSource.append(next).append("#");
                        continue;
                    }
                    SignPublisher.append(next, hmacSource);
                }
                continue;
            }
            if (obj instanceof Map) {
                Map map = (Map)obj;
                for (Object key : map.keySet()) {
                    Object value = map.get(key);
                    SignPublisher.append(value, hmacSource);
                }
                continue;
            }
            if (obj instanceof Enum) {
                String strTmp = StringUtils.defaultString((String)obj.toString(), (String)"");
                if (StringUtils.isBlank((CharSequence)strTmp)) continue;
                hmacSource.append(strTmp).append("#");
                continue;
            }
            if (SignPublisher.isPrimitiveClass(type)) {
                Object tmp = ObjectUtils.defaultIfNull((Object)obj, (Object)"");
                if (StringUtils.isBlank((CharSequence)tmp.toString())) continue;
                hmacSource.append(tmp).append("#");
                continue;
            }
            if (obj == null) continue;
            SignPublisher.append(obj, hmacSource);
        }
    }

    private static void append(Object obj, StringBuilder hmacSource) throws IllegalAccessException {
        if (obj == null) {
            return;
        }
        ArrayList<String> fields = new ArrayList<String>();
        Class<?> clazz = obj.getClass();
        SignPublisher.sortField(clazz, fields);
        SignPublisher.append(obj, fields, hmacSource);
    }

    private static Field findParentField(Object obj, String fieldName) {
        Class<?> parent = obj.getClass().getSuperclass();
        Field field = null;
        while (parent != null && parent != Object.class) {
            try {
                field = parent.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                parent = parent.getSuperclass();
            }
            if (field == null) continue;
            break;
        }
        return field;
    }

    private static boolean isPrimitiveClass(Class<?> clazz) {
        return clazz != null && primitiveClasses.contains(clazz);
    }

    static {
        primitiveClasses.add(Boolean.TYPE);
        primitiveClasses.add(Boolean.class);
        primitiveClasses.add(Character.TYPE);
        primitiveClasses.add(Character.class);
        primitiveClasses.add(Byte.TYPE);
        primitiveClasses.add(Byte.class);
        primitiveClasses.add(Short.TYPE);
        primitiveClasses.add(Short.class);
        primitiveClasses.add(Integer.TYPE);
        primitiveClasses.add(Integer.class);
        primitiveClasses.add(Long.TYPE);
        primitiveClasses.add(Long.class);
        primitiveClasses.add(Float.TYPE);
        primitiveClasses.add(Float.class);
        primitiveClasses.add(Double.TYPE);
        primitiveClasses.add(Double.class);
        primitiveClasses.add(BigInteger.class);
        primitiveClasses.add(BigDecimal.class);
        primitiveClasses.add(String.class);
        primitiveClasses.add(java.util.Date.class);
        primitiveClasses.add(Date.class);
        primitiveClasses.add(Time.class);
        primitiveClasses.add(Timestamp.class);
    }
}

