/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.by_1_52.crypto.paddings;

import java.security.SecureRandom;
import org.bouncycastle.by_1_52.crypto.InvalidCipherTextException;
import org.bouncycastle.by_1_52.crypto.paddings.BlockCipherPadding;

public class PKCS7Padding
implements BlockCipherPadding {
    @Override
    public void init(SecureRandom random) throws IllegalArgumentException {
    }

    @Override
    public String getPaddingName() {
        return "PKCS7";
    }

    @Override
    public int addPadding(byte[] in, int inOff) {
        byte code = (byte)(in.length - inOff);
        while (inOff < in.length) {
            in[inOff] = code;
            ++inOff;
        }
        return code;
    }

    @Override
    public int padCount(byte[] in) throws InvalidCipherTextException {
        int count = in[in.length - 1] & 0xFF;
        byte countAsbyte = (byte)count;
        boolean failed = count > in.length | count == 0;
        for (int i = 0; i < in.length; ++i) {
            failed |= in.length - i <= count & in[i] != countAsbyte;
        }
        if (failed) {
            throw new InvalidCipherTextException("pad block corrupted");
        }
        return count;
    }
}

