/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.by_1_52.crypto.prng;

import java.security.SecureRandom;
import org.bouncycastle.by_1_52.crypto.prng.EntropySource;
import org.bouncycastle.by_1_52.crypto.prng.EntropySourceProvider;

public class BasicEntropySourceProvider
implements EntropySourceProvider {
    private final SecureRandom _sr;
    private final boolean _predictionResistant;

    public BasicEntropySourceProvider(SecureRandom random, boolean isPredictionResistant) {
        this._sr = random;
        this._predictionResistant = isPredictionResistant;
    }

    @Override
    public EntropySource get(final int bitsRequired) {
        return new EntropySource(){

            @Override
            public boolean isPredictionResistant() {
                return BasicEntropySourceProvider.this._predictionResistant;
            }

            @Override
            public byte[] getEntropy() {
                return BasicEntropySourceProvider.this._sr.generateSeed((bitsRequired + 7) / 8);
            }

            @Override
            public int entropySize() {
                return bitsRequired;
            }
        };
    }
}

