/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.by_1_52.crypto.signers;

import java.math.BigInteger;
import java.util.Hashtable;
import org.bouncycastle.by_1_52.crypto.AsymmetricBlockCipher;
import org.bouncycastle.by_1_52.crypto.CipherParameters;
import org.bouncycastle.by_1_52.crypto.CryptoException;
import org.bouncycastle.by_1_52.crypto.Digest;
import org.bouncycastle.by_1_52.crypto.Signer;
import org.bouncycastle.by_1_52.crypto.params.RSAKeyParameters;
import org.bouncycastle.by_1_52.util.Arrays;
import org.bouncycastle.by_1_52.util.BigIntegers;
import org.bouncycastle.by_1_52.util.Integers;

public class X931Signer
implements Signer {
    public static final int TRAILER_IMPLICIT = 188;
    public static final int TRAILER_RIPEMD160 = 12748;
    public static final int TRAILER_RIPEMD128 = 13004;
    public static final int TRAILER_SHA1 = 13260;
    public static final int TRAILER_SHA256 = 13516;
    public static final int TRAILER_SHA512 = 13772;
    public static final int TRAILER_SHA384 = 14028;
    public static final int TRAILER_WHIRLPOOL = 14284;
    public static final int TRAILER_SHA224 = 14540;
    private static Hashtable trailerMap = new Hashtable();
    private Digest digest;
    private AsymmetricBlockCipher cipher;
    private RSAKeyParameters kParam;
    private int trailer;
    private int keyBits;
    private byte[] block;

    public X931Signer(AsymmetricBlockCipher cipher, Digest digest, boolean implicit) {
        this.cipher = cipher;
        this.digest = digest;
        if (implicit) {
            this.trailer = 188;
        } else {
            Integer trailerObj = (Integer)trailerMap.get(digest.getAlgorithmName());
            if (trailerObj != null) {
                this.trailer = trailerObj;
            } else {
                throw new IllegalArgumentException("no valid trailer for digest");
            }
        }
    }

    public X931Signer(AsymmetricBlockCipher cipher, Digest digest) {
        this(cipher, digest, false);
    }

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        this.kParam = (RSAKeyParameters)param;
        this.cipher.init(forSigning, this.kParam);
        this.keyBits = this.kParam.getModulus().bitLength();
        this.block = new byte[(this.keyBits + 7) / 8];
        this.reset();
    }

    private void clearBlock(byte[] block) {
        for (int i = 0; i != block.length; ++i) {
            block[i] = 0;
        }
    }

    @Override
    public void update(byte b) {
        this.digest.update(b);
    }

    @Override
    public void update(byte[] in, int off, int len) {
        this.digest.update(in, off, len);
    }

    @Override
    public void reset() {
        this.digest.reset();
    }

    @Override
    public byte[] generateSignature() throws CryptoException {
        this.createSignatureBlock();
        BigInteger t = new BigInteger(1, this.cipher.processBlock(this.block, 0, this.block.length));
        BigInteger nSubT = this.kParam.getModulus().subtract(t);
        this.clearBlock(this.block);
        BigInteger v = this.kParam.getModulus().shiftRight(2);
        if (t.compareTo(nSubT) > 0) {
            return BigIntegers.asUnsignedByteArray((this.kParam.getModulus().bitLength() + 7) / 8, nSubT);
        }
        return BigIntegers.asUnsignedByteArray((this.kParam.getModulus().bitLength() + 7) / 8, t);
    }

    private void createSignatureBlock() {
        int delta;
        int digSize = this.digest.getDigestSize();
        if (this.trailer == 188) {
            delta = this.block.length - digSize - 1;
            this.digest.doFinal(this.block, delta);
            this.block[this.block.length - 1] = -68;
        } else {
            delta = this.block.length - digSize - 2;
            this.digest.doFinal(this.block, delta);
            this.block[this.block.length - 2] = (byte)(this.trailer >>> 8);
            this.block[this.block.length - 1] = (byte)this.trailer;
        }
        this.block[0] = 107;
        for (int i = delta - 2; i != 0; --i) {
            this.block[i] = -69;
        }
        this.block[delta - 1] = -70;
    }

    @Override
    public boolean verifySignature(byte[] signature) {
        BigInteger f;
        try {
            this.block = this.cipher.processBlock(signature, 0, signature.length);
        }
        catch (Exception e) {
            return false;
        }
        BigInteger t = new BigInteger(this.block);
        if (t.mod(BigInteger.valueOf(16L)).equals(BigInteger.valueOf(12L))) {
            f = t;
        } else {
            t = this.kParam.getModulus().subtract(t);
            if (t.mod(BigInteger.valueOf(16L)).equals(BigInteger.valueOf(12L))) {
                f = t;
            } else {
                return false;
            }
        }
        this.createSignatureBlock();
        byte[] fBlock = BigIntegers.asUnsignedByteArray(this.block.length, f);
        boolean rv = Arrays.constantTimeAreEqual(this.block, fBlock);
        this.clearBlock(this.block);
        this.clearBlock(fBlock);
        return rv;
    }

    static {
        trailerMap.put("RIPEMD128", Integers.valueOf(13004));
        trailerMap.put("RIPEMD160", Integers.valueOf(12748));
        trailerMap.put("SHA-1", Integers.valueOf(13260));
        trailerMap.put("SHA-224", Integers.valueOf(14540));
        trailerMap.put("SHA-256", Integers.valueOf(13516));
        trailerMap.put("SHA-384", Integers.valueOf(14028));
        trailerMap.put("SHA-512", Integers.valueOf(13772));
        trailerMap.put("Whirlpool", Integers.valueOf(14284));
    }
}

