/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.by_1_52.pqc.crypto.ntru;

import org.bouncycastle.by_1_52.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.by_1_52.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.by_1_52.crypto.KeyGenerationParameters;
import org.bouncycastle.by_1_52.pqc.crypto.ntru.NTRUEncryptionKeyGenerationParameters;
import org.bouncycastle.by_1_52.pqc.crypto.ntru.NTRUEncryptionPrivateKeyParameters;
import org.bouncycastle.by_1_52.pqc.crypto.ntru.NTRUEncryptionPublicKeyParameters;
import org.bouncycastle.by_1_52.pqc.math.ntru.polynomial.DenseTernaryPolynomial;
import org.bouncycastle.by_1_52.pqc.math.ntru.polynomial.IntegerPolynomial;
import org.bouncycastle.by_1_52.pqc.math.ntru.polynomial.Polynomial;
import org.bouncycastle.by_1_52.pqc.math.ntru.polynomial.ProductFormPolynomial;
import org.bouncycastle.by_1_52.pqc.math.ntru.util.Util;

public class NTRUEncryptionKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private NTRUEncryptionKeyGenerationParameters params;

    @Override
    public void init(KeyGenerationParameters param) {
        this.params = (NTRUEncryptionKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DenseTernaryPolynomial g;
        IntegerPolynomial fq;
        Polynomial t;
        int N = this.params.N;
        int q = this.params.q;
        int df = this.params.df;
        int df1 = this.params.df1;
        int df2 = this.params.df2;
        int df3 = this.params.df3;
        int dg = this.params.dg;
        boolean fastFp = this.params.fastFp;
        boolean sparse = this.params.sparse;
        IntegerPolynomial fp = null;
        while (true) {
            IntegerPolynomial f;
            if (fastFp) {
                t = this.params.polyType == 0 ? Util.generateRandomTernary(N, df, df, sparse, this.params.getRandom()) : ProductFormPolynomial.generateRandom(N, df1, df2, df3, df3, this.params.getRandom());
                f = t.toIntegerPolynomial();
                f.mult(3);
                f.coeffs[0] = f.coeffs[0] + 1;
            } else {
                t = this.params.polyType == 0 ? Util.generateRandomTernary(N, df, df - 1, sparse, this.params.getRandom()) : ProductFormPolynomial.generateRandom(N, df1, df2, df3, df3 - 1, this.params.getRandom());
                f = t.toIntegerPolynomial();
                fp = f.invertF3();
                if (fp == null) continue;
            }
            if ((fq = f.invertFq(q)) != null) break;
        }
        if (fastFp) {
            fp = new IntegerPolynomial(N);
            fp.coeffs[0] = 1;
        }
        while ((g = DenseTernaryPolynomial.generateRandom(N, dg, dg - 1, this.params.getRandom())).invertFq(q) == null) {
        }
        IntegerPolynomial h = g.mult(fq, q);
        h.mult3(q);
        h.ensurePositive(q);
        g.clear();
        fq.clear();
        NTRUEncryptionPrivateKeyParameters priv = new NTRUEncryptionPrivateKeyParameters(h, t, fp, this.params.getEncryptionParameters());
        NTRUEncryptionPublicKeyParameters pub = new NTRUEncryptionPublicKeyParameters(h, this.params.getEncryptionParameters());
        return new AsymmetricCipherKeyPair(pub, priv);
    }
}

