/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.by_1_52.pqc.jcajce.provider.rainbow;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.by_1_52.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.by_1_52.pqc.crypto.rainbow.RainbowKeyGenerationParameters;
import org.bouncycastle.by_1_52.pqc.crypto.rainbow.RainbowKeyPairGenerator;
import org.bouncycastle.by_1_52.pqc.crypto.rainbow.RainbowParameters;
import org.bouncycastle.by_1_52.pqc.crypto.rainbow.RainbowPrivateKeyParameters;
import org.bouncycastle.by_1_52.pqc.crypto.rainbow.RainbowPublicKeyParameters;
import org.bouncycastle.by_1_52.pqc.jcajce.provider.rainbow.BCRainbowPrivateKey;
import org.bouncycastle.by_1_52.pqc.jcajce.provider.rainbow.BCRainbowPublicKey;
import org.bouncycastle.by_1_52.pqc.jcajce.spec.RainbowParameterSpec;

public class RainbowKeyPairGeneratorSpi
extends KeyPairGenerator {
    RainbowKeyGenerationParameters param;
    RainbowKeyPairGenerator engine = new RainbowKeyPairGenerator();
    int strength = 1024;
    SecureRandom random = new SecureRandom();
    boolean initialised = false;

    public RainbowKeyPairGeneratorSpi() {
        super("Rainbow");
    }

    @Override
    public void initialize(int strength, SecureRandom random) {
        this.strength = strength;
        this.random = random;
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof RainbowParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a RainbowParameterSpec");
        }
        RainbowParameterSpec rainbowParams = (RainbowParameterSpec)params;
        this.param = new RainbowKeyGenerationParameters(random, new RainbowParameters(rainbowParams.getVi()));
        this.engine.init(this.param);
        this.initialised = true;
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.param = new RainbowKeyGenerationParameters(this.random, new RainbowParameters(new RainbowParameterSpec().getVi()));
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
        RainbowPublicKeyParameters pub = (RainbowPublicKeyParameters)pair.getPublic();
        RainbowPrivateKeyParameters priv = (RainbowPrivateKeyParameters)pair.getPrivate();
        return new KeyPair(new BCRainbowPublicKey(pub), new BCRainbowPrivateKey(priv));
    }
}

