/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.by_1_52.util.test;

import java.io.PrintStream;
import org.bouncycastle.by_1_52.util.Arrays;
import org.bouncycastle.by_1_52.util.test.SimpleTestResult;
import org.bouncycastle.by_1_52.util.test.Test;
import org.bouncycastle.by_1_52.util.test.TestFailedException;
import org.bouncycastle.by_1_52.util.test.TestResult;

public abstract class SimpleTest
implements Test {
    @Override
    public abstract String getName();

    private TestResult success() {
        return SimpleTestResult.successful(this, "Okay");
    }

    protected void fail(String message) {
        throw new TestFailedException(SimpleTestResult.failed(this, message));
    }

    protected void fail(String message, Throwable throwable) {
        throw new TestFailedException(SimpleTestResult.failed(this, message, throwable));
    }

    protected void fail(String message, Object expected, Object found) {
        throw new TestFailedException(SimpleTestResult.failed(this, message, expected, found));
    }

    protected boolean areEqual(byte[] a, byte[] b) {
        return Arrays.areEqual(a, b);
    }

    @Override
    public TestResult perform() {
        try {
            this.performTest();
            return this.success();
        }
        catch (TestFailedException e) {
            return e.getResult();
        }
        catch (Exception e) {
            return SimpleTestResult.failed(this, "Exception: " + e, e);
        }
    }

    protected static void runTest(Test test) {
        SimpleTest.runTest(test, System.out);
    }

    protected static void runTest(Test test, PrintStream out) {
        TestResult result = test.perform();
        out.println(result.toString());
        if (result.getException() != null) {
            result.getException().printStackTrace(out);
        }
    }

    public abstract void performTest() throws Exception;
}

