/*
 * Decompiled with CFR 0.152.
 */
package com.umpay.http;

import com.google.gson.Gson;
import com.umpay.http.UMFHttpClient;
import com.umpay.mer.ConfigContext;
import com.umpay.util.RSAUtil;
import com.umpay.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.lf5.util.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UMFFileClient {
    private static final Logger log = LoggerFactory.getLogger(UMFFileClient.class);
    public static final String CHARSET = "UTF-8";
    public static final String FILE = "file";
    public static final String DATA = "data";
    public static final String RULE = "spay";
    public static final int STATUS_200 = 200;
    public static final int STATUS_302 = 302;
    public static int CONNECTTIMEOUT = 6000;
    public static int SOCKETTIMEOUT = 120000;

    public static Map<String, Object> post(ConfigContext apicontext, Object obj, File file) throws Exception {
        String url = apicontext.getUrl();
        String merId = apicontext.getMerId();
        String rsaCharset = apicontext.getCharset();
        if (rsaCharset == null || "".equals(rsaCharset)) {
            rsaCharset = CHARSET;
        }
        Gson gson = new Gson();
        String body = gson.toJson(obj);
        String sign = RSAUtil.createSign(body, merId, RULE, rsaCharset);
        return UMFFileClient.post(url, body, file, sign, rsaCharset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Object> post(String url, String json, File file, String sign, String charset) throws Exception {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(CONNECTTIMEOUT).setSocketTimeout(SOCKETTIMEOUT).build();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
        if (StringUtils.isEmpty(charset)) {
            charset = CHARSET;
        }
        HttpPost httpPost = new HttpPost(url);
        if (sign != null && !"".equals(sign.trim())) {
            httpPost.setHeader("Signature", sign);
        }
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.addPart(FILE, (ContentBody)new FileBody(file));
        multipartEntityBuilder.addPart(DATA, (ContentBody)new StringBody(json, ContentType.TEXT_PLAIN));
        HttpEntity entity = multipartEntityBuilder.build();
        httpPost.setEntity(entity);
        CloseableHttpResponse response = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            try {
                response = httpClient.execute((HttpUriRequest)httpPost);
                int statusCode = response.getStatusLine().getStatusCode();
                String result = null;
                if (statusCode != 200) {
                    if (statusCode != 302) {
                        httpPost.abort();
                        throw new RuntimeException("HttpClient,error status code :" + statusCode);
                    }
                    result = response.getHeaders("location")[0].getValue();
                } else {
                    entity = response.getEntity();
                    if (entity != null) {
                        result = EntityUtils.toString((HttpEntity)entity, (String)charset);
                    }
                    Header[] headers = response.getAllHeaders();
                    EntityUtils.consume((HttpEntity)entity);
                    map.put("header", headers);
                }
                map.put("statusCode", statusCode);
                map.put(DATA, result);
                return map;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (response == null) return map;
                response.close();
                return map;
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    public static void download(ConfigContext apicontext, Map<String, String> reqMap, String filtPath) throws Exception {
        String plain = UMFHttpClient.getPlain(reqMap);
        String plainEncode = UMFHttpClient.getPlainEncode(reqMap);
        String url = apicontext.getUrl();
        String merId = apicontext.getMerId();
        String charset = apicontext.getCharset();
        if (charset == null || "".equals(charset)) {
            charset = CHARSET;
        }
        String sign = RSAUtil.createSign(plain, merId, RULE, charset);
        log.info(String.format("\u7b7e\u540d\uff1a%s", sign));
        UMFFileClient.download(String.valueOf(url) + "?" + plainEncode, sign, charset, filtPath);
    }

    public static void download(String url, String sign, String charset, String filePath) throws Exception {
        block15: {
            if (StringUtils.isEmpty(url)) {
                throw new RuntimeException("HttpClient,error url:" + url);
            }
            RequestConfig config = RequestConfig.custom().setConnectTimeout(CONNECTTIMEOUT).setSocketTimeout(SOCKETTIMEOUT).build();
            CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
            if (StringUtils.isEmpty(charset)) {
                charset = CHARSET;
            }
            HttpGet httpget = new HttpGet(url);
            if (sign != null && !"".equals(sign.trim())) {
                httpget.setHeader("Signature", sign);
            }
            CloseableHttpResponse response = null;
            try {
                try {
                    response = httpClient.execute((HttpUriRequest)httpget);
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode != 200) {
                        httpget.abort();
                        throw new RuntimeException("HttpClient,error status code :" + statusCode);
                    }
                    HttpEntity entity = response.getEntity();
                    if (entity == null) break block15;
                    File desc = new File(filePath);
                    File folder = desc.getParentFile();
                    folder.mkdirs();
                    InputStream is = null;
                    FileOutputStream os = null;
                    try {
                        try {
                            is = entity.getContent();
                            os = new FileOutputStream(desc);
                            StreamUtils.copy((InputStream)is, (OutputStream)os);
                        }
                        catch (Exception e) {
                            UMFFileClient.close(is, os);
                            e.printStackTrace();
                            UMFFileClient.close(is, os);
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        UMFFileClient.close(is, os);
                        throw throwable;
                    }
                    UMFFileClient.close(is, os);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (response != null) {
                        response.close();
                    }
                }
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
    }

    private static void close(InputStream is, OutputStream os) throws Exception {
        if (is != null) {
            is.close();
        }
        if (os != null) {
            os.close();
        }
    }
}

