/*
 * Decompiled with CFR 0.152.
 */
package com.umpay.util;

import java.nio.ByteBuffer;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class DES3Util {
    private static final int DES_SAND = 305419896;
    private static final String digits = "0123456789abcdef";

    public static String encrypt3DES(String info, String desKey) throws Exception {
        if (info == null || "".equals(info)) {
            return "";
        }
        byte[] key = desKey.getBytes();
        byte[] encryptInfo = DES3Util.cipher(DES3Util.padding(info.getBytes("GBK")), key, 1, "DESede/ECB/NoPadding");
        return DES3Util.byte2HexString(encryptInfo);
    }

    public static String decrypt3DES(String info, String desKey) throws Exception {
        if (info == null || "".equals(info)) {
            return "";
        }
        byte[] key = desKey.getBytes();
        byte[] decryptInfo = DES3Util.cipher(DES3Util.hexStr2Byte(info), key, 2, "DESede/ECB/NoPadding");
        return new String(DES3Util.unpadding(decryptInfo), "GBK");
    }

    public static String encrypt(String srcMsg, String desKey) {
        String desStr = null;
        try {
            byte[] srcByteGbk = srcMsg.getBytes("GBK");
            byte[] destMsg = DES3Util.encTDes(srcByteGbk, desKey.getBytes());
            desStr = DES3Util.byte2HexString(destMsg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return desStr;
    }

    public static String decrypt(String desStr, String desKey) throws Exception {
        if (desStr == null || "".equals(desStr)) {
            return "";
        }
        byte[] key = desKey.getBytes();
        byte[] decryptInfo = DES3Util.decTDes(DES3Util.hexStr2Byte(desStr), key);
        return new String(decryptInfo, "GBK");
    }

    public static byte[] encTDes(byte[] binfo, byte[] bDesKey) throws Exception {
        return DES3Util.cipher(binfo, bDesKey, 1, "DES/ECB/PKCS5Padding");
    }

    public static byte[] decTDes(byte[] binfo, byte[] bDesKey) throws Exception {
        return DES3Util.cipher(binfo, bDesKey, 2, "DES/ECB/PKCS5Padding");
    }

    private static byte[] padding(byte[] src) {
        int mod = src.length % 8;
        byte[] pad = mod == 0 ? new byte[8 + src.length] : new byte[8 + src.length + 8 - mod];
        DES3Util.int2net(305419896, pad, 0);
        DES3Util.int2net(src.length, pad, 4);
        System.arraycopy(src, 0, pad, 8, src.length);
        return pad;
    }

    private static byte[] unpadding(byte[] buf) {
        int sand = DES3Util.net2int(buf, 0);
        if (sand != 305419896) {
            return null;
        }
        int len = DES3Util.net2int(buf, 4);
        byte[] unpad = new byte[len];
        System.arraycopy(buf, 8, unpad, 0, unpad.length);
        return unpad;
    }

    private static void int2net(int i, byte[] buf4, int offset) {
        buf4[offset + 0] = (byte)(i >>> 24 & 0xFF);
        buf4[offset + 1] = (byte)(i >>> 16 & 0xFF);
        buf4[offset + 2] = (byte)(i >>> 8 & 0xFF);
        buf4[offset + 3] = (byte)(i & 0xFF);
    }

    private static int net2int(byte[] buf, int offset) {
        int i = (buf[offset + 0] & 0xFF) << 24 | (buf[offset + 1] & 0xFF) << 16 | (buf[offset + 2] & 0xFF) << 8 | buf[offset + 3] & 0xFF;
        return i;
    }

    public static byte[] cipher(byte[] info, byte[] bDesKey, int mode, String transformation) throws Exception {
        String[] algs = transformation.split("/");
        SecretKeySpec key = new SecretKeySpec(bDesKey, algs[0]);
        Cipher c1 = Cipher.getInstance(transformation);
        c1.init(mode, key);
        return c1.doFinal(info);
    }

    private static String byte2HexString(byte[] data) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i != data.length) {
            int v = data[i] & 0xFF;
            buf.append(digits.charAt(v >> 4));
            buf.append(digits.charAt(v & 0xF));
            ++i;
        }
        return buf.toString().toUpperCase();
    }

    public static byte[] hexStr2Byte(String hex) {
        ByteBuffer bf = ByteBuffer.allocate(hex.length() / 2);
        int i = 0;
        while (i < hex.length()) {
            String hexStr = String.valueOf(hex.charAt(i));
            hexStr = String.valueOf(hexStr) + hex.charAt(++i);
            byte b = (byte)Integer.parseInt(hexStr, 16);
            bf.put(b);
            ++i;
        }
        return bf.array();
    }

    public static void main(String[] args) {
        try {
            String str1 = DES3Util.encrypt3DES("\u6c49\u5b57", "RfjNLMcZoKzbaTCsYvbnbPLr");
            String str2 = DES3Util.decrypt3DES("6ED373B101ECDBB7279EBBF97D3016D7", "RfjNLMcZoKzbaTCsYvbnbPLr");
            System.out.println(str1);
            System.out.println(str2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

