/*
 * Decompiled with CFR 0.152.
 */
package com.fengyan.smdh.admin.erp.register.controller;

import com.fengyan.smdh.admin.erp.register.manager.RegisterManager;
import com.fengyan.smdh.admin.shiro.base.core.encrpty.ShiroEncrpty;
import com.fengyan.smdh.components.core.utils.StringHelper;
import com.fengyan.smdh.components.redis.wrapper.RedisTemplateWrapper;
import com.fengyan.smdh.components.sms.ISMSSend;
import com.fengyan.smdh.components.webportal.http.RtnHttp;
import com.fengyan.smdh.entity.enterprise.EnterpriseUser;
import com.fengyan.smdh.modules.enterprise.service.admin.IEnterpriseUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="RegisterController", tags={"\u7528\u6237\u6ce8\u518c"})
@RestController
@RequestMapping(value={"/register"})
public class RegisterController {
    @Autowired
    private IEnterpriseUserService userService;
    @Autowired
    private RegisterManager registerManager;
    @Autowired
    private RedisTemplateWrapper redisTemplateWrapper;
    @Autowired
    private ISMSSend smsSend;
    private static final String PC_ERP_REGISTER_RANDOM_CODE = "PC_ERP_REGISTER_RANDOM_CODE:";

    @ApiOperation(value="\u6ce8\u518c", notes="\u6ce8\u518c")
    @GetMapping(value={"/registerUser"})
    public RtnHttp registerUser(String mobile, String password, String randomCode) {
        EnterpriseUser user = this.userService.getUserByLoginNameOrMobile(mobile);
        if (null != user) {
            return RtnHttp.error((String)"\u624b\u673a\u53f7\u5df2\u7ecf\u88ab\u4f7f\u7528\uff01");
        }
        user = new EnterpriseUser();
        user.setLoginName(mobile);
        user.setName(mobile);
        user.setMobile(mobile);
        user.setPassword(ShiroEncrpty.entryptPassword((String)password));
        this.registerManager.initial(user);
        return RtnHttp.ok();
    }

    @ApiOperation(value="\u83b7\u53d6\u9a8c\u8bc1\u7801", notes="\u83b7\u53d6\u9a8c\u8bc1\u7801")
    @GetMapping(value={"/getRegisterCode"})
    public RtnHttp getRegisterCode(String mobile) {
        EnterpriseUser user = this.userService.getUserByLoginNameOrMobile(mobile);
        if (null != user) {
            return RtnHttp.error((String)"\u624b\u673a\u53f7\u5df2\u7ecf\u88ab\u4f7f\u7528\uff01");
        }
        user = new EnterpriseUser();
        String randomCode = StringHelper.vefCod();
        System.out.println("==================================code================================>>>" + randomCode);
        try {
            Map result = this.smsSend.sendErpRegister(mobile, randomCode);
            if (!"OK".equals(result.get("code"))) {
                return RtnHttp.error((String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u9519\u8bef\u4ee3\u7801\uff1a\" + result.get(\"message\") + \"\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
            }
            this.redisTemplateWrapper.set((Object)(PC_ERP_REGISTER_RANDOM_CODE + mobile), (Object)randomCode);
        }
        catch (Exception e) {
            return RtnHttp.error((String)"\u56e0\u672a\u77e5\u539f\u56e0\u5bfc\u81f4\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
        }
        return RtnHttp.ok();
    }

    @ApiOperation(value="web\u7aefajax\u9a8c\u8bc1\u624b\u673a\u9a8c\u8bc1\u7801\u662f\u5426\u6b63\u786e", notes="web\u7aefajax\u9a8c\u8bc1\u624b\u673a\u9a8c\u8bc1\u7801\u662f\u5426\u6b63\u786e")
    @GetMapping(value={"/validateMobileCode"})
    public RtnHttp validateMobileCode(String mobile, String randomCode) {
        String code = (String)this.redisTemplateWrapper.get(PC_ERP_REGISTER_RANDOM_CODE + mobile);
        if (randomCode.equals(code)) {
            return RtnHttp.ok();
        }
        return RtnHttp.error((String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
    }
}

