/*
 * Decompiled with CFR 0.152.
 */
package com.fengyan.smdh.admin.erp.register.manager;

import com.fengyan.smdh.components.core.utils.StringUtils;
import com.fengyan.smdh.components.exception.BusinessException;
import com.fengyan.smdh.components.exception.ErrorCode;
import com.fengyan.smdh.components.mobile.service.MobileService;
import com.fengyan.smdh.components.redis.wrapper.StringRedisTemplateWrapper;
import com.fengyan.smdh.components.sms.ISMSSend;
import com.fengyan.smdh.entity.enterprise.Enterprise;
import com.fengyan.smdh.entity.enterprise.EnterpriseBase;
import com.fengyan.smdh.entity.enterprise.EnterpriseUser;
import com.fengyan.smdh.modules.customer.service.manager.CustomerManager;
import com.fengyan.smdh.modules.distribution.service.manager.DistributionManager;
import com.fengyan.smdh.modules.enterprise.service.manager.EnterpriseManager;
import com.fengyan.smdh.modules.setting.system.service.impl.SystemSettingSync;
import com.fengyan.smdh.modules.setting.template.manager.TemplateManager;
import com.fengyan.smdh.modules.setting.user.service.IUserIconService;
import com.fengyan.smdh.modules.supplier.service.manager.SupplierManager;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="registerManager")
public class RegisterManager {
    @Autowired
    @Qualifier(value="stringRedisTemplateWrapper")
    private StringRedisTemplateWrapper stringRedisTemplateWrapper;
    @Autowired
    private SystemSettingSync systemSettingSync;
    @Autowired
    private EnterpriseManager enterpriseManager;
    @Autowired
    private SupplierManager supplierManager;
    @Autowired
    private CustomerManager customerManager;
    @Autowired
    private TemplateManager templateManager;
    @Autowired
    private DistributionManager distributionManager;
    @Autowired
    private IUserIconService userIconService;
    @Autowired
    private MobileService mobileService;
    @Autowired
    private ISMSSend smsSend;

    @Transactional(rollbackFor={RuntimeException.class})
    public String initial(EnterpriseUser user) {
        EnterpriseBase base = this.enterpriseManager.getEnterpriseBase();
        Enterprise enterprise = this.enterpriseManager.initialEnterprise(base.getFreeSpace(), base.getFreeSms(), base.getFreeDays());
        String enterpriseId = enterprise.getEnterpriseId();
        if (StringUtils.isNotBlank((CharSequence)enterpriseId)) {
            user.setCompanyId(Integer.valueOf(Integer.parseInt(enterpriseId)));
        }
        String deptId = this.enterpriseManager.initialEnterpriseDept(enterpriseId);
        String leaderId = this.enterpriseManager.saveEnterpriseUser(user, enterpriseId, deptId);
        try {
            this.enterpriseManager.initialEnterpriseRole(enterpriseId);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCode.INITIAL_ENTERPRISE_USER_ROLE);
        }
        this.enterpriseManager.initialUserRole(enterpriseId, leaderId);
        this.enterpriseManager.initialEnterpriseProduct(enterpriseId, base.getFreeDays());
        String goodTypeId = this.enterpriseManager.initGoodsType(enterpriseId);
        try {
            this.enterpriseManager.initialGoodsUnit(enterpriseId);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCode.INITIAL_GOODS_UNIT);
        }
        try {
            this.enterpriseManager.initialGoodsLabel(enterpriseId);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCode.INITIAL_GOODS_LABLE);
        }
        String warehouseTypeId = this.enterpriseManager.initialWarehouseType(enterpriseId);
        this.enterpriseManager.initialWarehouse(enterpriseId, warehouseTypeId);
        this.enterpriseManager.initialLogistics(enterpriseId);
        this.supplierManager.initialFinancing(enterpriseId);
        this.supplierManager.initial(enterpriseId);
        this.enterpriseManager.initialFixedAddress(enterpriseId);
        Map map = this.customerManager.initial(enterpriseId);
        this.templateManager.initial(enterpriseId);
        this.enterpriseManager.initialShopPayment(Integer.valueOf(Integer.parseInt(enterpriseId)));
        this.enterpriseManager.initialShopSetting(Integer.valueOf(Integer.parseInt(enterpriseId)), (Integer)map.get("vipId"), (Integer)map.get("customerTypeId"), Integer.valueOf(Integer.parseInt(goodTypeId)));
        this.enterpriseManager.initialShopBottom(Integer.valueOf(Integer.parseInt(enterpriseId)));
        this.enterpriseManager.initialDictTable(Integer.valueOf(Integer.parseInt(enterpriseId)));
        this.enterpriseManager.initialDictBase(Integer.valueOf(Integer.parseInt(enterpriseId)));
        this.distributionManager.initialDistributionSetting(enterpriseId);
        this.enterpriseManager.createReportEnterprise(enterpriseId);
        this.enterpriseManager.insertCopy(enterpriseId);
        this.userIconService.create(enterpriseId, Long.valueOf(Long.parseLong(leaderId)));
        enterprise.setEnterpriseLeader(Integer.valueOf(Integer.parseInt(leaderId)));
        this.enterpriseManager.updateEnterprise(enterprise);
        if (base.isRegisterNotifyAdmin()) {
            String registerPhone = user.getMobile();
            String city = this.mobileService.getCity(registerPhone);
            this.smsSend.sendErpRegisterSuccessNotifyAdmin(base.getAdminPhone(), registerPhone, city);
        }
        this.stringRedisTemplateWrapper.set("space:total:{enterpriseId}".replace("{enterpriseId}", enterpriseId), (Object)enterprise.getTotalSpace());
        this.stringRedisTemplateWrapper.set("space:use:{enterpriseId}".replace("{enterpriseId}", enterpriseId), (Object)0);
        this.stringRedisTemplateWrapper.set("sms:total:{enterpriseId}".replace("{enterpriseId}", enterpriseId), (Object)enterprise.getTotalSms());
        this.stringRedisTemplateWrapper.set("sms:use:{enterpriseId}".replace("{enterpriseId}", enterpriseId), (Object)0);
        this.systemSettingSync.sync(enterpriseId);
        return enterpriseId;
    }
}

