/*
 * Decompiled with CFR 0.152.
 */
package com.fengyan.smdh.components.wechat.helper;

import com.fengyan.smdh.components.core.utils.OKHttpHelper;
import com.fengyan.smdh.components.core.utils.StringUtils;
import com.fengyan.smdh.components.exception.BusinessException;
import com.fengyan.smdh.components.webportal.HttpContextHelper;
import com.fengyan.smdh.components.wechat.entity.MerchantInfo;
import com.fengyan.smdh.components.wechat.entity.PayInfo;
import com.fengyan.smdh.components.wechat.entity.WXPInfo;
import com.fengyan.smdh.components.wechat.util.PayUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;

public class PayHelper {
    private static String unifiedOrderUrl = "https://api.mch.weixin.qq.com/pay/unifiedorder";
    private static String orderQueryUrl = "https://api.mch.weixin.qq.com/pay/orderquery";

    private PayHelper() {
    }

    public static String orderQuery(Map<String, String> params) {
        return OKHttpHelper.postXml((String)orderQueryUrl, (String)PayUtil.toXml(params));
    }

    public static String pushOrder(Map<String, String> params) {
        return OKHttpHelper.postXml((String)unifiedOrderUrl, (String)PayUtil.toXml(params));
    }

    public static Map<String, String> baseParams(MerchantInfo merchant, TradeType tradeType, PayInfo pay) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appid", merchant.getAppId());
        params.put("mch_id", merchant.getMchId());
        params.put("body", merchant.getBody());
        params.put("out_trade_no", pay.getOutTradeNo());
        params.put("total_fee", pay.getTotalFee());
        params.put("spbill_create_ip", pay.getIp());
        params.put("trade_type", tradeType.name());
        params.put("nonce_str", pay.getNonceStr());
        params.put("notify_url", pay.getNotifyUrl());
        if (TradeType.JSAPI.equals((Object)tradeType)) {
            params.put("openid", pay.getOpenId());
        } else if (TradeType.NATIVE.equals((Object)tradeType)) {
            params.put("product_id", pay.getProductId());
        }
        String sign = PayUtil.createSign(params, merchant.getMchKey());
        params.put("sign", sign);
        return params;
    }

    public static Map<String, String> pushOrder(MerchantInfo merchant, TradeType tradeType, PayInfo pay) {
        Map<String, String> params = PayHelper.baseParams(merchant, tradeType, pay);
        String xmlResult = PayHelper.pushOrder(params);
        Map<String, String> result = PayUtil.xmlToMap(xmlResult);
        String return_code = result.get("return_code");
        String return_msg = result.get("return_msg");
        if (StringUtils.isBlank((CharSequence)return_code) || !"SUCCESS".equals(return_code)) {
            throw new BusinessException(return_msg);
        }
        String result_code = result.get("result_code");
        if (StringUtils.isBlank((CharSequence)result_code) || !"SUCCESS".equals(result_code)) {
            throw new BusinessException(return_msg);
        }
        return result;
    }

    public static String getOrderId(String enterpriseId, Long orderTime) {
        String orderId = enterpriseId + "-" + orderTime + "-" + RandomStringUtils.random((int)6, (boolean)false, (boolean)true);
        return orderId;
    }

    public static Map<String, String> JSAPIRtn(MerchantInfo merchant, PayInfo pay) {
        Map<String, String> result = PayHelper.pushOrder(merchant, TradeType.JSAPI, pay);
        String prepayId = result.get("prepay_id");
        HashMap<String, String> payParams = new HashMap<String, String>();
        payParams.put("appId", merchant.getAppId());
        payParams.put("timeStamp", System.currentTimeMillis() / 1000L + "");
        payParams.put("nonceStr", System.currentTimeMillis() + "");
        payParams.put("package", "prepay_id=" + prepayId);
        payParams.put("signType", "MD5");
        System.out.println(payParams);
        String packageSign = PayUtil.createSign(payParams, merchant.getMchKey());
        payParams.put("paySign", packageSign);
        System.out.println(payParams);
        return payParams;
    }

    public static Map<String, String> orderQuery(WXPInfo wxpInfo) {
        HashMap<String, String> orderReq = new HashMap<String, String>();
        orderReq.put("appid", wxpInfo.getAppId());
        orderReq.put("mch_id", wxpInfo.getMchId());
        orderReq.put("out_trade_no", wxpInfo.getOrderId());
        orderReq.put("nonce_str", System.currentTimeMillis() + "");
        orderReq.put("sign_type", "MD5");
        String packageSign = PayUtil.createSign(orderReq, wxpInfo.getMchKey());
        orderReq.put("sign", packageSign);
        String result = PayHelper.orderQuery(orderReq);
        return PayUtil.xmlToMap(result);
    }

    public static Map<String, String> notifyParams() {
        String xmlMsg = HttpContextHelper.readData();
        Map<String, String> params = PayUtil.xmlToMap(xmlMsg);
        return params;
    }

    public static enum TradeType {
        JSAPI,
        NATIVE,
        APP,
        WAP,
        MWEB;

    }
}

