/*
 * Decompiled with CFR 0.152.
 */
package com.fengyan.smdh.components.wechat.helper;

import com.alibaba.fastjson.JSON;
import com.fengyan.smdh.components.core.utils.OKHttpHelper;
import com.fengyan.smdh.components.wechat.entity.AccessToken;
import com.fengyan.smdh.components.wechat.entity.UserInfo;

public abstract class UserInfoHelper {
    private static String accessTokenUrl = "https://api.weixin.qq.com/sns/oauth2/access_token?appid={appId}&secret={secret}&code={code}&grant_type=authorization_code";
    public static String smallAccessTokenUrl = "https://api.weixin.qq.com/sns/jscode2session?appid={appId}&secret={secret}&js_code={code}&grant_type=authorization_code";
    private static String userInfoUrl = "https://api.weixin.qq.com/sns/userinfo?access_token={accessToken}&openid={openId}&lang=zh_CN";

    private UserInfoHelper() {
    }

    public static String getSmallOpenId(String appId, String secret, String code) {
        AccessToken accessToken = UserInfoHelper.getSmallAccessToken(appId, secret, code);
        return accessToken.getOpenId();
    }

    public static AccessToken getSmallAccessToken(String appId, String secret, String code) {
        String url = smallAccessTokenUrl.replace("{appId}", appId).replace("{secret}", secret).replace("{code}", code);
        String json = OKHttpHelper.get((String)url);
        AccessToken accessToken = (AccessToken)JSON.parseObject((String)json, AccessToken.class);
        return accessToken;
    }

    public static String getOpenId(String appId, String secret, String code) {
        AccessToken accessToken = UserInfoHelper.getAccessToken(appId, secret, code);
        return accessToken.getOpenId();
    }

    public static AccessToken getAccessToken(String appId, String secret, String code) {
        String url = accessTokenUrl.replace("{appId}", appId).replace("{secret}", secret).replace("{code}", code);
        String json = OKHttpHelper.get((String)url);
        AccessToken accessToken = (AccessToken)JSON.parseObject((String)json, AccessToken.class);
        return accessToken;
    }

    public static UserInfo getUserInfo(String openId, String accessToken) {
        String url = userInfoUrl.replace("{openId}", openId).replace("{accessToken}", accessToken);
        String json = OKHttpHelper.get((String)url);
        UserInfo userInfo = (UserInfo)JSON.parseObject((String)json, UserInfo.class);
        return userInfo;
    }
}

