/*
 * Decompiled with CFR 0.152.
 */
package com.fengyan.smdh.components.wechat.util;

import com.fengyan.smdh.components.wechat.util.AESUtil;
import com.fengyan.smdh.components.wechat.util.XmlUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.Charsets;
import org.apache.commons.lang3.StringUtils;

public class PayUtil {
    public static String packageSign(Map<String, String> params, boolean urlEncoder) {
        TreeMap<String, String> sortedParams = new TreeMap<String, String>(params);
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> param : sortedParams.entrySet()) {
            String value = param.getValue();
            if (StringUtils.isBlank((CharSequence)value)) continue;
            if (first) {
                first = false;
            } else {
                sb.append("&");
            }
            sb.append(param.getKey()).append("=");
            if (urlEncoder) {
                try {
                    value = PayUtil.urlEncode(value);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            sb.append(value);
        }
        return sb.toString();
    }

    public static String urlEncode(String src) throws UnsupportedEncodingException {
        return URLEncoder.encode(src, Charsets.UTF_8.name()).replace("+", "%20");
    }

    private static String urlDecode(String src) throws UnsupportedEncodingException {
        return URLDecoder.decode(src, Charsets.UTF_8.name());
    }

    public static String createSign(Map<String, String> params, String paternerKey) {
        params.remove("sign");
        String stringA = PayUtil.packageSign(params, false);
        String stringSignTemp = stringA + "&key=" + paternerKey;
        return AESUtil.md5(stringSignTemp).toUpperCase();
    }

    public static boolean verifyNotify(Map<String, String> params, String paternerKey) {
        String sign = params.get("sign");
        String localSign = PayUtil.createSign(params, paternerKey);
        return sign.equals(localSign);
    }

    public static String toXml(Map<String, String> params) {
        StringBuilder xml = new StringBuilder();
        xml.append("<xml>");
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.isBlank((CharSequence)value)) continue;
            xml.append("<").append(key).append(">");
            xml.append(entry.getValue());
            xml.append("</").append(key).append(">");
        }
        xml.append("</xml>");
        return xml.toString();
    }

    public static Map<String, String> xmlToMap(String xmlStr) {
        XmlUtil xml = XmlUtil.of(xmlStr);
        return xml.toMap();
    }
}

