/*
 * Decompiled with CFR 0.152.
 */
package com.fengyan.smdh.modules.attachment.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.fengyan.smdh.components.exception.BusinessException;
import com.fengyan.smdh.components.exception.ErrorCode;
import com.fengyan.smdh.components.exception.SystemException;
import com.fengyan.smdh.entity.attachment.TempAttachment;
import com.fengyan.smdh.entity.image.ImageInfo;
import com.fengyan.smdh.modules.attachment.mapper.TempAttachmentMapper;
import com.fengyan.smdh.modules.attachment.service.ITempShopAttachmentService;
import com.fengyan.smdh.modules.image.service.IImageInfoService;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tempShopAttachmentService")
public class TempShopAttachmentServiceImpl
extends ServiceImpl<TempAttachmentMapper, TempAttachment>
implements ITempShopAttachmentService {
    @Autowired
    @Qualifier(value="imageInfoService")
    private IImageInfoService imageInfoService;
    @Autowired
    @Qualifier(value="redisTemplate")
    private RedisTemplate redisTemplate;

    @Override
    @Transactional
    public TempAttachment createTempAttachment(String userId, String style, ImageInfo imageInfo) {
        try {
            TempAttachment tempAttachment = new TempAttachment();
            tempAttachment.setAttachmentId(Long.valueOf(new RedisAtomicLong("attach_AutoIncrementId", this.redisTemplate.getConnectionFactory()).incrementAndGet()));
            tempAttachment.setIsCoverImg(imageInfo.getIsCoverImg());
            tempAttachment.setName(imageInfo.getName());
            tempAttachment.setSize(imageInfo.getSize());
            tempAttachment.setGarment(imageInfo.getGarment());
            tempAttachment.setAttachmentUrl(imageInfo.getUrl());
            tempAttachment.setOriginalUrl(imageInfo.getOriginalUrl());
            tempAttachment.setImgStyle(style);
            tempAttachment.setCreateBy(userId);
            if (!this.save(tempAttachment)) {
                throw new BusinessException(ErrorCode.BUSINESS_UNKNOWN_ERROR);
            }
            return tempAttachment;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    @Override
    public List<TempAttachment> getTempAttachmentByDate(Date date) {
        QueryWrapper entityWrapper = new QueryWrapper();
        entityWrapper.le((Object)"create_time", (Object)date);
        List list = this.list((Wrapper)entityWrapper);
        return list;
    }

    @Override
    @Transactional
    public void clearTempAttachmentByDate(Date date) {
        QueryWrapper entityWrapper = new QueryWrapper();
        entityWrapper.le((Object)"create_time", (Object)date);
        this.remove((Wrapper)entityWrapper);
    }
}

