/*
 * Decompiled with CFR 0.152.
 */
package com.fengyan.smdh.modules.financing.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.fengyan.smdh.components.exception.BusinessException;
import com.fengyan.smdh.entity.financing.FinancingAccounts;
import com.fengyan.smdh.entity.financing.FinancingDetails;
import com.fengyan.smdh.entity.financing.FinancingSubject;
import com.fengyan.smdh.modules.financing.mapper.FinancingAccountsMapper;
import com.fengyan.smdh.modules.financing.service.IFinancingAccountsService;
import com.fengyan.smdh.modules.financing.service.IFinancingDetailsService;
import com.fengyan.smdh.modules.financing.service.IFinancingSubjectService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="financingAccountsService")
public class FinancingAccountsServiceImpl
extends ServiceImpl<FinancingAccountsMapper, FinancingAccounts>
implements IFinancingAccountsService {
    @Autowired
    private IFinancingSubjectService subjectService;
    @Autowired
    private IFinancingDetailsService detailsService;

    @Override
    public void accountBalance(Integer id, BigDecimal value) {
        UpdateWrapper uw = new UpdateWrapper();
        uw.setSql("account_balance = account_balance + " + value.toString());
        uw.lambda().eq(FinancingAccounts::getId, (Object)id);
        if (!this.update(new FinancingAccounts(), (Wrapper)uw)) {
            throw new BusinessException();
        }
    }

    @Override
    public List<FinancingAccounts> showAccounts(String enterpriseId, Integer accountType) {
        QueryWrapper qw = new QueryWrapper();
        ((LambdaQueryWrapper)qw.lambda().eq(FinancingAccounts::getEnterpriseId, (Object)enterpriseId)).eq(FinancingAccounts::getAccountType, (Object)accountType);
        return ((FinancingAccountsMapper)this.baseMapper).selectList((Wrapper)qw);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public String initialAccounts(FinancingAccounts accounts) {
        FinancingSubject financingNumber = new FinancingSubject();
        FinancingSubject parent = new FinancingSubject();
        financingNumber.setParent(parent);
        financingNumber.setEnterpriseId(accounts.getEnterpriseId());
        financingNumber.getParent().setNumber("1002");
        Integer maxNumber = this.subjectService.getMaxNumberThree(financingNumber);
        String tempNumber = maxNumber + 1 + "";
        String number = "1002";
        FinancingSubject getSubject = this.subjectService.getNumberSubject(number);
        FinancingSubject financingSubject = new FinancingSubject();
        financingSubject.setEnterpriseId(accounts.getEnterpriseId());
        financingSubject.setName(accounts.getOpeningBank());
        financingSubject.setNumber(tempNumber);
        financingSubject.setBorrowLoan("\u501f");
        financingSubject.setMnemonicCode(accounts.getMnemonicCode());
        financingSubject.setParentId(getSubject.getId());
        financingSubject.setParentIds(getSubject.getParentIds() + getSubject.getId() + ",");
        Date date = new Date();
        financingSubject.setCreateDate(date);
        financingSubject.setUpdateDate(date);
        this.subjectService.save(financingSubject);
        Integer id = financingSubject.getId();
        FinancingDetails detailsBegin = new FinancingDetails();
        detailsBegin.setEnterpriseId(accounts.getEnterpriseId().toString());
        detailsBegin.setDebtorMoney(BigDecimal.ZERO);
        detailsBegin.setLenderMoney(BigDecimal.ZERO);
        detailsBegin.setDebtorAdd(BigDecimal.ZERO);
        detailsBegin.setLenderAdd(BigDecimal.ZERO);
        detailsBegin.setBeginBalance(BigDecimal.ZERO);
        detailsBegin.setEndBalance(BigDecimal.ZERO);
        detailsBegin.setParentType(id);
        detailsBegin.setDetailsType("\u671f\u521d");
        detailsBegin.setCreateDate(date);
        detailsBegin.setUpdateDate(date);
        this.detailsService.detailsInsert(detailsBegin);
        return id.toString();
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void accountsInsert(FinancingAccounts accounts) {
        ((FinancingAccountsMapper)this.baseMapper).accountsInsert(accounts);
    }
}

