/*
 * Decompiled with CFR 0.152.
 */
package com.fengyan.smdh.modules.financing.service.manager;

import com.fengyan.smdh.components.core.utils.DateUtils;
import com.fengyan.smdh.entity.financing.FinancingAccounts;
import com.fengyan.smdh.entity.financing.FinancingDetails;
import com.fengyan.smdh.entity.financing.FinancingPeriod;
import com.fengyan.smdh.entity.financing.FinancingSettleAccounts;
import com.fengyan.smdh.entity.financing.FinancingSubject;
import com.fengyan.smdh.modules.financing.service.IFinancingAccountsService;
import com.fengyan.smdh.modules.financing.service.IFinancingCustomerDetailsService;
import com.fengyan.smdh.modules.financing.service.IFinancingDetailsService;
import com.fengyan.smdh.modules.financing.service.IFinancingPeriodService;
import com.fengyan.smdh.modules.financing.service.IFinancingSettleAccountsService;
import com.fengyan.smdh.modules.financing.service.IFinancingSubjectService;
import com.fengyan.smdh.modules.financing.service.IFinancingVoucherService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="financingManager")
public class FinancingManager {
    @Autowired
    @Qualifier(value="financingSubjectService")
    private IFinancingSubjectService subjectService;
    @Autowired
    @Qualifier(value="financingAccountsService")
    private IFinancingAccountsService accountsService;
    @Autowired
    @Qualifier(value="financingCustomerDetailsService")
    private IFinancingCustomerDetailsService customerDetailsService;
    @Autowired
    @Qualifier(value="financingDetailsService")
    private IFinancingDetailsService detailsService;
    @Autowired
    @Qualifier(value="financingPeriodService")
    private IFinancingPeriodService periodService;
    @Autowired
    @Qualifier(value="financingSettleAccountsService")
    private IFinancingSettleAccountsService settleAccountsService;
    @Autowired
    @Qualifier(value="financingVoucherService")
    private IFinancingVoucherService voucherService;

    @Transactional(rollbackFor={RuntimeException.class})
    public void initial(String enterpriseId) {
        Date date = new Date();
        String number = "100201";
        FinancingSubject weiXinSubject = this.subjectService.getNumberSubject(number);
        FinancingAccounts weiXin = new FinancingAccounts();
        weiXin.setEnterpriseId(Integer.valueOf(Integer.parseInt(enterpriseId)));
        weiXin.setParent(weiXinSubject);
        weiXin.setFinancingNumber("yhzh001");
        weiXin.setOpeningBank("\u4e2a\u4eba\u5fae\u4fe1\u8d26\u6237");
        weiXin.setOpeningBranch("\u4e2a\u4eba\u5fae\u4fe1\u8d26\u6237");
        weiXin.setMnemonicCode("GRWXZH");
        weiXin.setIsShopping(Integer.valueOf(0));
        weiXin.setAccountType(Integer.valueOf(0));
        weiXin.setCreateDate(date);
        weiXin.setUpdateDate(date);
        weiXin.setDelFlag("0");
        String weiXinId = this.accountsService.initialAccounts(weiXin);
        FinancingSubject WXSubject = this.subjectService.getOne(weiXinId);
        weiXin.setParentType(WXSubject.getId());
        this.accountsService.accountsInsert(weiXin);
        String zhiNumber = "100202";
        FinancingSubject zhiFuBaoSubject = this.subjectService.getNumberSubject(zhiNumber);
        FinancingAccounts zhiFuBao = new FinancingAccounts();
        zhiFuBao.setEnterpriseId(Integer.valueOf(Integer.parseInt(enterpriseId)));
        zhiFuBao.setParent(zhiFuBaoSubject);
        zhiFuBao.setFinancingNumber("yhzh002");
        zhiFuBao.setOpeningBank("\u4e2a\u4eba\u652f\u4ed8\u5b9d\u8d26\u6237");
        zhiFuBao.setOpeningBranch("\u4e2a\u4eba\u652f\u4ed8\u5b9d\u8d26\u6237");
        zhiFuBao.setMnemonicCode("GRZFBZH");
        zhiFuBao.setIsShopping(Integer.valueOf(0));
        zhiFuBao.setAccountType(Integer.valueOf(0));
        zhiFuBao.setCreateDate(date);
        zhiFuBao.setUpdateDate(date);
        zhiFuBao.setDelFlag("0");
        String zhiFuBaoId = this.accountsService.initialAccounts(zhiFuBao);
        FinancingSubject ZFBSubject = this.subjectService.getOne(zhiFuBaoId);
        zhiFuBao.setParentType(ZFBSubject.getId());
        this.accountsService.accountsInsert(zhiFuBao);
        FinancingAccounts xianWeiXin = new FinancingAccounts();
        xianWeiXin.setEnterpriseId(Integer.valueOf(Integer.parseInt(enterpriseId)));
        xianWeiXin.setFinancingNumber("yhzh003");
        xianWeiXin.setOpeningBank("\u5bf9\u516c\u5fae\u4fe1\u8d26\u6237");
        xianWeiXin.setOpeningBranch("\u5bf9\u516c\u5fae\u4fe1\u8d26\u6237");
        xianWeiXin.setMnemonicCode("DGWXZH");
        xianWeiXin.setIsShopping(Integer.valueOf(0));
        xianWeiXin.setAccountType(Integer.valueOf(1));
        xianWeiXin.setCreateDate(date);
        xianWeiXin.setUpdateDate(date);
        xianWeiXin.setDelFlag("0");
        String xianWeiId = this.accountsService.initialAccounts(xianWeiXin);
        FinancingSubject xianWeiXinSubject = this.subjectService.getOne(xianWeiId);
        xianWeiXin.setParentType(xianWeiXinSubject.getId());
        this.accountsService.accountsInsert(xianWeiXin);
        FinancingAccounts xianZhiFuBao = new FinancingAccounts();
        xianZhiFuBao.setEnterpriseId(Integer.valueOf(Integer.parseInt(enterpriseId)));
        xianZhiFuBao.setFinancingNumber("yhzh004");
        xianZhiFuBao.setOpeningBank("\u5bf9\u516c\u652f\u4ed8\u5b9d\u8d26\u6237");
        xianZhiFuBao.setOpeningBranch("\u5bf9\u516c\u652f\u4ed8\u5b9d\u8d26\u6237");
        xianZhiFuBao.setMnemonicCode("DGZFBZH");
        xianZhiFuBao.setIsShopping(Integer.valueOf(0));
        xianZhiFuBao.setAccountType(Integer.valueOf(2));
        xianZhiFuBao.setCreateDate(date);
        xianZhiFuBao.setUpdateDate(date);
        xianZhiFuBao.setDelFlag("0");
        String xianZhiId = this.accountsService.initialAccounts(xianZhiFuBao);
        FinancingSubject xianZhiFuBaoSubject = this.subjectService.getOne(xianZhiId);
        xianZhiFuBao.setParentType(xianZhiFuBaoSubject.getId());
        this.accountsService.accountsInsert(xianZhiFuBao);
        FinancingAccounts xianJin = new FinancingAccounts();
        xianJin.setEnterpriseId(Integer.valueOf(Integer.parseInt(enterpriseId)));
        xianJin.setFinancingNumber("yhzh005");
        xianJin.setOpeningBank("\u73b0\u91d1\u8d26\u6237");
        xianJin.setOpeningBranch("\u73b0\u91d1\u8d26\u6237");
        xianJin.setMnemonicCode("XJZH");
        xianJin.setIsShopping(Integer.valueOf(0));
        xianJin.setAccountType(Integer.valueOf(3));
        xianJin.setCreateDate(date);
        xianJin.setUpdateDate(date);
        xianJin.setDelFlag("0");
        String xianJinId = this.accountsService.initialAccounts(xianJin);
        FinancingSubject xianJinSubject = this.subjectService.getOne(xianJinId);
        xianJin.setParentType(xianJinSubject.getId());
        this.accountsService.accountsInsert(xianJin);
        FinancingAccounts platformBalance = new FinancingAccounts();
        platformBalance.setEnterpriseId(Integer.valueOf(Integer.parseInt(enterpriseId)));
        platformBalance.setFinancingNumber("yhzh006");
        platformBalance.setOpeningBank("\u5e73\u53f0\u4f59\u989d\u8d26\u6237");
        platformBalance.setOpeningBranch("\u5e73\u53f0\u4f59\u989d\u8d26\u6237");
        platformBalance.setMnemonicCode("PTYEZH");
        platformBalance.setIsShopping(Integer.valueOf(0));
        platformBalance.setAccountType(Integer.valueOf(4));
        platformBalance.setCreateDate(date);
        platformBalance.setUpdateDate(date);
        platformBalance.setDelFlag("0");
        String platformBalanceId = this.accountsService.initialAccounts(platformBalance);
        FinancingSubject platformBalanceSubject = this.subjectService.getOne(platformBalanceId);
        platformBalance.setParentType(platformBalanceSubject.getId());
        this.accountsService.accountsInsert(platformBalance);
        FinancingAccounts platformCredit = new FinancingAccounts();
        platformCredit.setEnterpriseId(Integer.valueOf(Integer.parseInt(enterpriseId)));
        platformCredit.setFinancingNumber("yhzh007");
        platformCredit.setOpeningBank("\u5e73\u53f0\u4fe1\u7528\u8d26\u6237");
        platformCredit.setOpeningBranch("\u5e73\u53f0\u4fe1\u7528\u8d26\u6237");
        platformCredit.setMnemonicCode("PTXYZH");
        platformCredit.setIsShopping(Integer.valueOf(0));
        platformCredit.setAccountType(Integer.valueOf(5));
        platformCredit.setCreateDate(date);
        platformCredit.setUpdateDate(date);
        platformCredit.setDelFlag("0");
        String platformCreditId = this.accountsService.initialAccounts(platformCredit);
        FinancingSubject platformCreditSubject = this.subjectService.getOne(platformCreditId);
        platformCredit.setParentType(platformCreditSubject.getId());
        this.accountsService.accountsInsert(platformCredit);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void initialFinancingDetails(String enterpriseId, String supplierId) {
        String payment = "1123";
        FinancingSubject financingPayment = this.subjectService.getNumberSubject(payment);
        FinancingDetails paymentDetails = new FinancingDetails();
        paymentDetails.setEnterpriseId(enterpriseId);
        paymentDetails.setParentType(financingPayment.getId());
        paymentDetails.setAssistType(Integer.valueOf(Integer.parseInt(supplierId)));
        paymentDetails.setDetailsType("\u4f9b\u5e94\u5546");
        paymentDetails.setSupplierId(supplierId);
        Date date = new Date();
        paymentDetails.setCreateDate(date);
        paymentDetails.setUpdateDate(date);
        this.detailsService.supplierCopy(paymentDetails);
        String payable = "2202";
        FinancingSubject financingPayable = this.subjectService.getNumberSubject(payable);
        FinancingDetails payableDetails = new FinancingDetails();
        payableDetails.setEnterpriseId(enterpriseId);
        payableDetails.setParentType(financingPayable.getId());
        payableDetails.setAssistType(Integer.valueOf(Integer.parseInt(supplierId)));
        payableDetails.setDetailsType("\u4f9b\u5e94\u5546");
        payableDetails.setSupplierId(supplierId);
        payableDetails.setCreateDate(date);
        payableDetails.setUpdateDate(date);
        this.detailsService.supplierCopy(payableDetails);
        Date startDate = DateUtils.firstDay((Date)new Date());
        Date checkDate = DateUtils.lastDay((Date)new Date());
        FinancingPeriod period = new FinancingPeriod();
        period.setEnterpriseId(Integer.valueOf(Integer.parseInt(enterpriseId)));
        period.setStartDate(startDate);
        period.setCheckDate(checkDate);
        period.setStatus(Integer.valueOf(1));
        period.setDelFlag("0");
        period.setCreateDate(date);
        period.setUpdateDate(date);
        this.periodService.periodInsert(period);
        FinancingSettleAccounts settleAccount = new FinancingSettleAccounts();
        settleAccount.setEnterpriseId(Integer.valueOf(Integer.parseInt(enterpriseId)));
        settleAccount.setAccountingYear(DateUtils.year());
        settleAccount.setAccountingMonth(DateUtils.month());
        settleAccount.setStartDate(startDate);
        settleAccount.setCheckDate(checkDate);
        settleAccount.setStatus(Integer.valueOf(0));
        settleAccount.setDelFlag("0");
        settleAccount.setCreateDate(date);
        settleAccount.setUpdateDate(date);
        this.settleAccountsService.settleInsert(settleAccount);
    }
}

