/*
 * Decompiled with CFR 0.152.
 */
package com.fengyan.smdh.modules.log.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.fengyan.smdh.api.entity.Bill;
import com.fengyan.smdh.components.exception.BusinessException;
import com.fengyan.smdh.entity.log.Log;
import com.fengyan.smdh.modules.log.mapper.LogMapper;
import com.fengyan.smdh.modules.log.service.ILogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;
import org.springframework.stereotype.Service;

@Service(value="logService")
public class LogServiceImpl
extends ServiceImpl<LogMapper, Log>
implements ILogService {
    @Autowired
    private RedisTemplate redisTemplate;

    @Override
    public void enterpriseBusinessLog(String enterpriseId, Integer userId, String title, String logDesc, Bill bill) {
        if (userId == null) {
            this.enterpriseBusinessLog(enterpriseId, "0", title, logDesc, bill);
        } else {
            this.enterpriseBusinessLog(enterpriseId, userId.toString(), title, logDesc, bill);
        }
    }

    @Override
    public void enterpriseBusinessLog(String enterpriseId, String userId, String title, String logDesc, Bill bill) {
        Log log = new Log();
        log.setCreateBy(Integer.valueOf(userId == null ? 0 : Integer.valueOf(userId)));
        log.setType("1");
        this.log(enterpriseId, title, logDesc, bill, log);
    }

    @Override
    public void customerBusinessLog(String enterpriseId, Integer customerId, String title, String logDesc, Bill bill) {
        if (customerId == null) {
            this.customerBusinessLog(enterpriseId, "0", title, logDesc, bill);
        } else {
            this.customerBusinessLog(enterpriseId, customerId.toString(), title, logDesc, bill);
        }
    }

    @Override
    public void customerBusinessLog(String enterpriseId, String customerId, String title, String logDesc, Bill bill) {
        Log log = new Log();
        log.setCreateBy(Integer.valueOf(customerId == null ? 0 : Integer.valueOf(customerId)));
        log.setType("0");
        this.log(enterpriseId, title, logDesc, bill, log);
    }

    public void log(String enterpriseId, String title, String logDesc, Bill bill, Log log) {
        log.setTitle(title);
        log.setEnterpriseId(enterpriseId);
        if (bill != null) {
            log.setBillId(bill.getBillId());
            log.setBillType(bill.getBillType());
            logDesc = "\u5355\u636e\u7f16\u53f7\uff1a" + bill.getBillNumber() + (logDesc == null ? "" : "\uff0c  " + logDesc);
        }
        log.setLogDesc(logDesc);
        RedisAtomicLong redisAtomicLong = new RedisAtomicLong("log2_AutoIncrementId", this.redisTemplate.getConnectionFactory());
        log.setLogId(Long.valueOf(redisAtomicLong.incrementAndGet()));
        if (!this.save(log)) {
            throw new BusinessException();
        }
    }
}

