/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaQrcodeService;
import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaCodeLineColor;
import cn.binarywang.wx.miniapp.bean.WxMaQrcode;
import cn.binarywang.wx.miniapp.bean.WxaCode;
import cn.binarywang.wx.miniapp.bean.WxaCodeUnlimit;
import cn.binarywang.wx.miniapp.util.QrcodeBytesRequestExecutor;
import cn.binarywang.wx.miniapp.util.QrcodeRequestExecutor;
import java.io.File;
import me.chanjar.weixin.common.error.WxErrorException;

public class WxMaQrcodeServiceImpl
implements WxMaQrcodeService {
    private WxMaService wxMaService;

    public WxMaQrcodeServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }

    @Override
    public byte[] createQrcodeBytes(String path, int width) throws WxErrorException {
        QrcodeBytesRequestExecutor executor = new QrcodeBytesRequestExecutor(this.wxMaService.getRequestHttp());
        return this.wxMaService.execute(executor, "https://api.weixin.qq.com/cgi-bin/wxaapp/createwxaqrcode", new WxMaQrcode(path, width));
    }

    @Override
    public File createQrcode(String path, int width) throws WxErrorException {
        QrcodeRequestExecutor executor = new QrcodeRequestExecutor(this.wxMaService.getRequestHttp());
        return this.wxMaService.execute(executor, "https://api.weixin.qq.com/cgi-bin/wxaapp/createwxaqrcode", new WxMaQrcode(path, width));
    }

    @Override
    public File createQrcode(String path) throws WxErrorException {
        return this.createQrcode(path, 430);
    }

    @Override
    public byte[] createWxaCodeBytes(String path, int width, boolean autoColor, WxMaCodeLineColor lineColor, boolean isHyaline) throws WxErrorException {
        QrcodeBytesRequestExecutor executor = new QrcodeBytesRequestExecutor(this.wxMaService.getRequestHttp());
        return this.wxMaService.execute(executor, "https://api.weixin.qq.com/wxa/getwxacode", WxaCode.builder().path(path).width(width).autoColor(autoColor).lineColor(lineColor).isHyaline(isHyaline).build());
    }

    @Override
    public File createWxaCode(String path, int width, boolean autoColor, WxMaCodeLineColor lineColor, boolean isHyaline) throws WxErrorException {
        QrcodeRequestExecutor executor = new QrcodeRequestExecutor(this.wxMaService.getRequestHttp());
        return this.wxMaService.execute(executor, "https://api.weixin.qq.com/wxa/getwxacode", WxaCode.builder().path(path).width(width).autoColor(autoColor).lineColor(lineColor).isHyaline(isHyaline).build());
    }

    @Override
    public File createWxaCode(String path, int width) throws WxErrorException {
        return this.createWxaCode(path, width, true, null, false);
    }

    @Override
    public File createWxaCode(String path) throws WxErrorException {
        return this.createWxaCode(path, 430);
    }

    @Override
    public byte[] createWxaCodeUnlimitBytes(String scene, String page, int width, boolean autoColor, WxMaCodeLineColor lineColor, boolean isHyaline) throws WxErrorException {
        return this.wxMaService.execute(new QrcodeBytesRequestExecutor(this.wxMaService.getRequestHttp()), "https://api.weixin.qq.com/wxa/getwxacodeunlimit", this.buildWxaCodeUnlimit(scene, page, width, autoColor, lineColor, isHyaline));
    }

    @Override
    public File createWxaCodeUnlimit(String scene, String page, int width, boolean autoColor, WxMaCodeLineColor lineColor, boolean isHyaline) throws WxErrorException {
        return this.wxMaService.execute(new QrcodeRequestExecutor(this.wxMaService.getRequestHttp()), "https://api.weixin.qq.com/wxa/getwxacodeunlimit", this.buildWxaCodeUnlimit(scene, page, width, autoColor, lineColor, isHyaline));
    }

    private WxaCodeUnlimit buildWxaCodeUnlimit(String scene, String page, int width, boolean autoColor, WxMaCodeLineColor lineColor, boolean isHyaline) {
        WxaCodeUnlimit wxaCodeUnlimit = new WxaCodeUnlimit();
        wxaCodeUnlimit.setScene(scene);
        wxaCodeUnlimit.setPage(page);
        wxaCodeUnlimit.setWidth(width);
        wxaCodeUnlimit.setAutoColor(autoColor);
        wxaCodeUnlimit.setLineColor(lineColor);
        wxaCodeUnlimit.setHyaline(isHyaline);
        return wxaCodeUnlimit;
    }

    @Override
    public File createWxaCodeUnlimit(String scene, String page) throws WxErrorException {
        return this.createWxaCodeUnlimit(scene, page, 430, true, null, false);
    }
}

