/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.proto.storage.internal;

import com.github.tobato.fastdfs.domain.MateData;
import com.github.tobato.fastdfs.proto.FdfsRequest;
import com.github.tobato.fastdfs.proto.ProtoHead;
import com.github.tobato.fastdfs.proto.mapper.DynamicFieldType;
import com.github.tobato.fastdfs.proto.mapper.FdfsColumn;
import com.github.tobato.fastdfs.proto.mapper.MetadataMapper;
import com.github.tobato.fastdfs.proto.storage.enums.StorageMetdataSetType;
import java.nio.charset.Charset;
import java.util.Set;
import org.apache.commons.lang3.Validate;

public class StorageSetMetadataRequest
extends FdfsRequest {
    @FdfsColumn(index=0)
    private int fileNameByteLengh;
    @FdfsColumn(index=1)
    private int mataDataByteLength;
    @FdfsColumn(index=2)
    private byte opFlag;
    @FdfsColumn(index=3, max=16)
    private String groupName;
    @FdfsColumn(index=4, dynamicField=DynamicFieldType.allRestByte)
    private String path;
    @FdfsColumn(index=5, dynamicField=DynamicFieldType.matedata)
    private Set<MateData> metaDataSet;

    public StorageSetMetadataRequest(String groupName, String path, Set<MateData> metaDataSet, StorageMetdataSetType type) {
        Validate.notBlank((CharSequence)groupName, (String)"\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)path, (String)"\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty(metaDataSet, (String)"\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)type), (String)"\u6807\u7b7e\u8bbe\u7f6e\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.groupName = groupName;
        this.path = path;
        this.metaDataSet = metaDataSet;
        this.opFlag = type.getType();
        this.head = new ProtoHead(13);
    }

    @Override
    public byte[] encodeParam(Charset charset) {
        this.fileNameByteLengh = this.path.getBytes(charset).length;
        this.mataDataByteLength = this.getMetaDataSetByteSize(charset);
        return super.encodeParam(charset);
    }

    private int getMetaDataSetByteSize(Charset charset) {
        return MetadataMapper.toByte(this.metaDataSet, charset).length;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Set<MateData> getMetaDataSet() {
        return this.metaDataSet;
    }

    public byte getOpFlag() {
        return this.opFlag;
    }

    public String getPath() {
        return this.path;
    }

    public int getFileNameByteLengh() {
        return this.fileNameByteLengh;
    }

    public int getMataDataByteLength() {
        return this.mataDataByteLength;
    }
}

