/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.auth;

import com.huaweicloud.sdk.core.auth.ICredential;
import com.huaweicloud.sdk.core.auth.TempCredentialHelper;
import com.huaweicloud.sdk.core.http.HttpClient;
import com.huaweicloud.sdk.core.http.HttpRequest;
import com.huaweicloud.sdk.core.internal.model.Credential;
import com.huaweicloud.sdk.core.utils.TimeUtils;
import java.util.Objects;
import java.util.function.Function;

public abstract class AbstractCredentials<DerivedT extends AbstractCredentials<DerivedT>>
implements ICredential {
    private String ak;
    private String sk;
    private String securityToken;
    private String iamEndpoint;
    protected Long expiredAt;
    protected String regionId;
    protected String derivedAuthServiceName;
    private Function<HttpRequest, Boolean> derivedPredicate;
    public static final Function<HttpRequest, Boolean> DEFAULT_DERIVED_PREDICATE = httpRequest -> !"^[a-z][a-z0-9-]+(\\.[a-z]{2,}-[a-z]+-\\d{1,2})?\\.(my)?(huaweicloud|myhwclouds).(com|cn)".matches(httpRequest.getEndpoint().replace("https://", ""));

    public abstract void processDerivedAuthParams(String var1, String var2);

    public String getAk() {
        return this.ak;
    }

    public void setAk(String ak) {
        this.ak = ak;
    }

    public String getSk() {
        return this.sk;
    }

    public void setSk(String sk) {
        this.sk = sk;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public String getIamEndpoint() {
        return this.iamEndpoint;
    }

    public void setIamEndpoint(String iamEndpoint) {
        this.iamEndpoint = iamEndpoint;
    }

    public Function<HttpRequest, Boolean> getDerivedPredicate() {
        return this.derivedPredicate;
    }

    public void setDerivedPredicate(Function<HttpRequest, Boolean> derivedPredicate) {
        this.derivedPredicate = derivedPredicate;
    }

    public DerivedT withAk(String ak) {
        this.ak = ak;
        return (DerivedT)this;
    }

    public DerivedT withSk(String sk) {
        this.sk = sk;
        return (DerivedT)this;
    }

    public DerivedT withSecurityToken(String securityToken) {
        this.securityToken = securityToken;
        return (DerivedT)this;
    }

    public DerivedT withIamEndpoint(String iamEndpoint) {
        this.iamEndpoint = iamEndpoint;
        return (DerivedT)this;
    }

    public DerivedT withDerivedPredicate(Function<HttpRequest, Boolean> derivedPredicate) {
        this.derivedPredicate = derivedPredicate;
        return (DerivedT)this;
    }

    protected boolean isDerivedAuth(HttpRequest httpRequest) {
        if (this.derivedPredicate == null) {
            return false;
        }
        return this.derivedPredicate.apply(httpRequest);
    }

    protected void updateCredential(HttpClient httpClient) {
        Credential credential = TempCredentialHelper.getTemporaryCredential(httpClient);
        TempCredentialHelper.updateCredential(this, credential);
    }

    protected boolean needUpdate() {
        if (Objects.isNull(this.expiredAt)) {
            return false;
        }
        return this.expiredAt - TimeUtils.getTimeInMillis() < 60000L;
    }
}

