/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.auth;

import com.huaweicloud.sdk.core.auth.AbstractCredentials;
import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.http.HttpRequest;
import com.huaweicloud.sdk.core.utils.BinaryUtils;
import com.huaweicloud.sdk.core.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.SimpleTimeZone;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class DerivedAKSKSigner {
    private static final String EMPTY_BODY_SHA256 = "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855";
    private static final String ISO_8601_BASIC_FORMAT = "yyyyMMdd'T'HHmmss'Z'";
    private static final SimpleDateFormat ISO_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
    private static final String V_11_HMAC_SHA_256 = "V11-HMAC-SHA256";

    public static Map<String, String> sign(HttpRequest request, AbstractCredentials credential) {
        String[] split;
        String dateTimeStamp;
        if (StringUtils.isEmpty(credential.regionId)) {
            throw new SdkException("regionId in credential is required when using derived auth");
        }
        if (StringUtils.isEmpty(credential.derivedAuthServiceName)) {
            throw new SdkException("derivedAuthServiceName in credential is required when using derived auth");
        }
        Date now = new Date();
        HashMap<String, String> authenticationHeaders = new HashMap<String, String>();
        URL url = request.getUrl();
        String canonicalHost = url.getAuthority();
        authenticationHeaders.put("Host", canonicalHost);
        if (!request.haveHeader("X-Sdk-Date").booleanValue()) {
            ISO_DATE_FORMAT.setTimeZone(new SimpleTimeZone(0, "UTC"));
            dateTimeStamp = ISO_DATE_FORMAT.format(now);
            authenticationHeaders.put("X-Sdk-Date", dateTimeStamp);
        } else {
            dateTimeStamp = request.getHeader("X-Sdk-Date");
        }
        TreeMap<String, String> allHeaders = new TreeMap<String, String>();
        allHeaders.putAll(request.getHeaders().entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith("Content-Type") || !((String)((List)entry.getValue()).get(0)).startsWith("multipart/form-data")).collect(Collectors.toMap(entry -> ((String)entry.getKey()).toLowerCase(Locale.ROOT), entry -> (String)((List)entry.getValue()).get(0))));
        allHeaders.putAll(authenticationHeaders.entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toLowerCase(Locale.ROOT), Map.Entry::getValue)));
        String pathOld = url.getPath();
        String canonicalUri = "";
        for (String urlSplit : split = pathOld.split("/")) {
            canonicalUri = canonicalUri + DerivedAKSKSigner.urlEncode(urlSplit) + "/";
        }
        String query = url.getQuery();
        Map<String, List<String>> parameters = request.getQueryParams();
        String canonicalQueryString = DerivedAKSKSigner.buildCanonicalQueryString(query, parameters);
        String signedHeaderNames = String.join((CharSequence)";", allHeaders.keySet());
        String canonicalHeaders = DerivedAKSKSigner.buildCanonicalHeaders(allHeaders);
        String payloadHash = DerivedAKSKSigner.buildPayloadHash(request);
        String canonicalRequest = DerivedAKSKSigner.buildCanonicalRequest(request.getMethod().name(), canonicalUri, canonicalQueryString, canonicalHeaders, signedHeaderNames, payloadHash);
        String canonicalRequestHash = BinaryUtils.toHex(DerivedAKSKSigner.sha256(canonicalRequest));
        String dateStr = LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE);
        String info = dateStr + "/" + credential.regionId + "/" + credential.derivedAuthServiceName;
        String stringToSign = DerivedAKSKSigner.getStringToSign(V_11_HMAC_SHA_256, dateTimeStamp, info, canonicalRequestHash);
        String derivationKey = HKDF.getDerKeySHA256(credential.getAk(), credential.getSk(), info);
        String signatureString = DerivedAKSKSigner.signature(stringToSign, derivationKey);
        StringBuilder authorization = new StringBuilder(V_11_HMAC_SHA_256).append(" ");
        authorization.append("Credential=").append(credential.getAk()).append("/").append(info).append(", ");
        authorization.append("SignedHeaders=").append(signedHeaderNames).append(", ");
        authorization.append("Signature=").append(signatureString);
        authenticationHeaders.put("Authorization", authorization.toString());
        return authenticationHeaders;
    }

    private static String buildCanonicalQueryString(String query, Map<String, List<String>> parameters) {
        SortedMap<String, List<String>> sorted = DerivedAKSKSigner.convertQuery2SortedMap(query);
        StringBuilder builder = new StringBuilder();
        if (parameters == null || parameters.isEmpty()) {
            return builder.toString();
        }
        for (Map.Entry<String, List<String>> pair : parameters.entrySet()) {
            String key = pair.getKey();
            List<String> values = pair.getValue();
            ArrayList<String> escapedValues = new ArrayList<String>();
            for (String value : values) {
                escapedValues.add(DerivedAKSKSigner.urlEncode(value));
            }
            sorted.put(DerivedAKSKSigner.urlEncode(key), escapedValues);
        }
        Iterator<Map.Entry<String, List<String>>> itr = sorted.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, List<String>> pair = itr.next();
            for (int i = 0; i < pair.getValue().size(); ++i) {
                builder.append(pair.getKey());
                builder.append("=");
                builder.append(pair.getValue().get(i));
                if (i >= pair.getValue().size() - 1) continue;
                builder.append("&");
            }
            if (pair.getValue().size() == 0) {
                builder.append(pair.getKey()).append("=");
            }
            if (!itr.hasNext()) continue;
            builder.append("&");
        }
        return builder.toString();
    }

    private static SortedMap<String, List<String>> convertQuery2SortedMap(String query) {
        String[] splitArr;
        TreeMap<String, List<String>> sorted = new TreeMap<String, List<String>>();
        if (query == null || query.isEmpty()) {
            return sorted;
        }
        for (String split : splitArr = query.split("&")) {
            String[] kv = split.split("=");
            if (kv.length != 2) continue;
            if (!sorted.containsKey(DerivedAKSKSigner.urlEncode(kv[0]))) {
                ArrayList<String> values = new ArrayList<String>();
                values.add(DerivedAKSKSigner.urlEncode(kv[1]));
                sorted.put(DerivedAKSKSigner.urlEncode(kv[0]), values);
                continue;
            }
            ((List)sorted.get(DerivedAKSKSigner.urlEncode(kv[0]))).add(DerivedAKSKSigner.urlEncode(kv[1]));
        }
        return sorted;
    }

    private static String buildCanonicalHeaders(Map<String, String> heads) {
        StringBuilder sb = new StringBuilder();
        heads.forEach((key, value) -> {
            sb.append((String)key).append(":").append((String)value);
            sb.append("\n");
        });
        return sb.toString();
    }

    private static String buildPayloadHash(HttpRequest request) {
        if (request.haveHeader("X-Sdk-Content-Sha256").booleanValue()) {
            return request.getHeader("X-Sdk-Content-Sha256");
        }
        if (Objects.nonNull(request.getBodyAsString()) && !request.getBodyAsString().isEmpty()) {
            return BinaryUtils.toHex(DerivedAKSKSigner.sha256(request.getBodyAsString()));
        }
        return EMPTY_BODY_SHA256;
    }

    private static String buildCanonicalRequest(String ... segments) {
        return String.join((CharSequence)"\n", segments);
    }

    private static String getStringToSign(String ... segments) {
        return String.join((CharSequence)"\n", segments);
    }

    private static String signature(String stringToSign, String secretKey) {
        byte[] keySecret = secretKey.getBytes(StandardCharsets.UTF_8);
        byte[] signature = DerivedAKSKSigner.hmac(keySecret, stringToSign);
        return BinaryUtils.toHex(signature);
    }

    private static String urlEncode(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8").replace("+", "%20").replace("*", "%2A");
        }
        catch (UnsupportedEncodingException e) {
            throw new SdkException("UTF-8 encoding is not supported.", e);
        }
    }

    private static byte[] sha256(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(text.getBytes(StandardCharsets.UTF_8));
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new SdkException("Unable to compute hash while signing request", e);
        }
    }

    private static byte[] hmac(byte[] key, String data) {
        try {
            Mac hmac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, "HmacSHA256");
            hmac.init(secretKeySpec);
            return hmac.doFinal(data.getBytes(StandardCharsets.UTF_8));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new SdkException("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }

    static class HKDF {
        private static final String HMAC_SHA1 = "hmacsha1";
        private static final String HMAC_SHA256 = "hmacsha256";
        private static final int DERIVATION_KEY_LENGTH = 32;
        private static final String HMAC_ALGORITHM = "hmacsha256";
        private static final int ALGORITHM_HASH_LENGTH = HKDF.getHashLen("hmacsha256");
        private static final Charset UTF_8 = StandardCharsets.UTF_8;
        private static final int EXPAND_CEIL = (int)Math.ceil(32.0 / (double)ALGORITHM_HASH_LENGTH);

        HKDF() {
        }

        public static String getDerKeySHA256(String accessKey, String secretKey, String info) {
            if (null == accessKey || "".equals(accessKey) || null == secretKey || "".equals(secretKey)) {
                return null;
            }
            try {
                byte[] tmpKey = HKDF.extract(secretKey.getBytes(UTF_8), accessKey.getBytes(UTF_8), "hmacsha256");
                byte[] derSecretKey = HKDF.expand(tmpKey, info.getBytes(UTF_8), "hmacsha256", 32, EXPAND_CEIL);
                if (null != derSecretKey) {
                    return HKDF.toHex(derSecretKey);
                }
            }
            catch (IOException | InvalidKeyException | NoSuchAlgorithmException e) {
                String msg = "Failed to derive AK " + accessKey + " with info " + info + " .";
                throw new SdkException(msg, e);
            }
            return null;
        }

        public static String toHex(byte[] data) {
            StringBuilder sb = new StringBuilder(data.length * 2);
            for (byte itemByte : data) {
                String hex = Integer.toHexString(itemByte);
                if (hex.length() == 1) {
                    sb.append("0");
                } else if (hex.length() == 8) {
                    hex = hex.substring(6);
                }
                sb.append(hex);
            }
            return sb.toString().toLowerCase(Locale.ROOT);
        }

        private static byte[] extract(byte[] ikm, byte[] salt, String hmacAlgorithm) throws NoSuchAlgorithmException, InvalidKeyException {
            if (salt == null || salt.length == 0) {
                salt = new byte[HKDF.getHashLen(hmacAlgorithm)];
            }
            Mac mac = Mac.getInstance(hmacAlgorithm);
            mac.init(new SecretKeySpec(salt, hmacAlgorithm));
            return mac.doFinal(ikm);
        }

        private static byte[] expand(byte[] prk, byte[] info, String hmacAlgorithm, int okmLength, int ceil) throws NoSuchAlgorithmException, InvalidKeyException, IOException {
            byte[] rawResult;
            Mac mac = Mac.getInstance(hmacAlgorithm);
            mac.init(new SecretKeySpec(prk, hmacAlgorithm));
            if (ceil == 1) {
                rawResult = HKDF.expandFirst(info, mac);
            } else {
                rawResult = new byte[]{};
                byte[] temp = new byte[]{};
                for (int i = 1; i <= ceil; ++i) {
                    temp = HKDF.expandOnce(info, mac, temp, i);
                    ByteArrayOutputStream combineBytes = new ByteArrayOutputStream();
                    combineBytes.write(rawResult);
                    combineBytes.write(temp);
                    rawResult = combineBytes.toByteArray();
                }
            }
            return okmLength == rawResult.length ? rawResult : (byte[])(okmLength < rawResult.length ? Arrays.copyOf(rawResult, okmLength) : null);
        }

        private static byte[] expandFirst(byte[] info, Mac mac) {
            byte[] result = new byte[info.length + 1];
            System.arraycopy(info, 0, result, 0, info.length);
            result[info.length] = 1;
            return mac.doFinal(result);
        }

        private static byte[] expandOnce(byte[] info, Mac mac, byte[] preTemp, int i) throws IOException {
            ByteArrayOutputStream hashBytes = new ByteArrayOutputStream();
            hashBytes.write(preTemp);
            hashBytes.write(info);
            hashBytes.write(i);
            return mac.doFinal(hashBytes.toByteArray());
        }

        private static int getHashLen(String hmacAlgorithm) {
            switch (hmacAlgorithm) {
                case "hmacsha1": {
                    return 20;
                }
            }
            return 32;
        }
    }
}

