/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.auth;

import com.huaweicloud.sdk.core.auth.AbstractCredentials;
import com.huaweicloud.sdk.core.auth.BasicCredentials;
import com.huaweicloud.sdk.core.auth.GlobalCredentials;
import com.huaweicloud.sdk.core.auth.ICredential;
import com.huaweicloud.sdk.core.http.HttpRequest;
import com.huaweicloud.sdk.core.utils.StringUtils;
import java.util.Objects;
import java.util.function.Function;

public final class EnvCredentialHelper {
    public static final String AK_ENV_NAME = "HUAWEICLOUD_SDK_AK";
    public static final String SK_ENV_NAME = "HUAWEICLOUD_SDK_SK";
    public static final String PROJECT_ID_ENV_NAME = "HUAWEICLOUD_SDK_PROJECT_ID";
    public static final String DOMAIN_ID_ENV_NAME = "HUAWEICLOUD_SDK_DOMAIN_ID";
    public static final String IAM_ENDPOINT_ENV_NAME = "HUAWEICLOUD_SDK_IAM_ENDPOINT";
    public static final String REGION_ID_ENV_NAME = "HUAWEICLOUD_SDK_REGION_ID";
    public static final String DERIVED_AUTH_SERVICE_NAME_ENV_NAME = "HUAWEICLOUD_SDK_DERIVED_AUTH_SERVICE_NAME";
    public static final String DERIVED_PREDICATE_ENV_NAME = "HUAWEICLOUD_SDK_DERIVED_PREDICATE";
    public static final String DEFAULT_DERIVED_PREDICATE = "DEFAULT_DERIVED_PREDICATE";

    private EnvCredentialHelper() {
    }

    public static ICredential loadCredentialFromEnv(String defaultType) {
        Function<HttpRequest, Boolean> derivedPredicate;
        String ak = System.getenv(AK_ENV_NAME);
        String sk = System.getenv(SK_ENV_NAME);
        if (StringUtils.isEmpty(ak) || StringUtils.isEmpty(sk)) {
            return null;
        }
        String regionId = System.getenv(REGION_ID_ENV_NAME);
        String derivedAuthServiceName = System.getenv(DERIVED_AUTH_SERVICE_NAME_ENV_NAME);
        Function<HttpRequest, Boolean> function = derivedPredicate = DEFAULT_DERIVED_PREDICATE.equals(System.getenv(DERIVED_PREDICATE_ENV_NAME)) ? AbstractCredentials.DEFAULT_DERIVED_PREDICATE : null;
        if ("BasicCredentials".equals(defaultType)) {
            BasicCredentials credentials = (BasicCredentials)((BasicCredentials)((BasicCredentials)new BasicCredentials().withAk(ak)).withSk(sk)).withDerivedPredicate(derivedPredicate);
            credentials.processDerivedAuthParams(derivedAuthServiceName, regionId);
            String projectId = System.getenv(PROJECT_ID_ENV_NAME);
            if (!StringUtils.isEmpty(projectId)) {
                credentials.setProjectId(projectId);
            }
            credentials.setIamEndpoint(EnvCredentialHelper.getIamEndpointEnvName());
            return credentials;
        }
        if ("GlobalCredentials".equals(defaultType)) {
            GlobalCredentials credentials = (GlobalCredentials)((GlobalCredentials)((GlobalCredentials)new GlobalCredentials().withAk(ak)).withSk(sk)).withDerivedPredicate(derivedPredicate);
            credentials.processDerivedAuthParams(derivedAuthServiceName, regionId);
            String domainId = System.getenv(DOMAIN_ID_ENV_NAME);
            if (!StringUtils.isEmpty(domainId)) {
                return credentials.withDomainId(domainId);
            }
            credentials.setIamEndpoint(EnvCredentialHelper.getIamEndpointEnvName());
            return credentials;
        }
        return null;
    }

    public static String getIamEndpointEnvName() {
        String iamEndpoint = System.getenv(IAM_ENDPOINT_ENV_NAME);
        if (Objects.isNull(iamEndpoint) || StringUtils.isEmpty(iamEndpoint)) {
            return null;
        }
        return iamEndpoint;
    }
}

