/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.retry;

import com.huaweicloud.sdk.core.exception.ConnectionException;
import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.exception.ServiceResponseException;
import com.huaweicloud.sdk.core.retry.RetryContext;
import com.huaweicloud.sdk.core.retry.backoff.BackoffStrategy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryRecord<ResT> {
    private final ThreadFactory namedFactory = RetryRecord.initNamedThreadFactory();
    private final ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(0, this.namedFactory);
    CompletableFuture<ResT> future;
    Supplier<CompletableFuture<ResT>> workSupplier;
    AtomicInteger retriesAttempted = new AtomicInteger(0);
    SdkException currException = null;
    boolean shouldRetry = false;
    int maxRetryTimes;
    BiFunction<ResT, SdkException, Boolean> func;
    BackoffStrategy backoffStrategy;

    public RetryRecord(int maxRetryTimes, BiFunction<ResT, SdkException, Boolean> func, BackoffStrategy backoffStrategy) {
        this.maxRetryTimes = maxRetryTimes;
        this.func = func;
        this.backoffStrategy = backoffStrategy;
    }

    public void perform(ScheduledExecutorService executor) {
        int currRetriesAttempted = this.retriesAttempted.incrementAndGet();
        this.workSupplier.get().whenComplete((resp, throwable) -> {
            if (Objects.isNull(resp) && Objects.isNull(throwable)) {
                this.future.completeExceptionally(new IllegalArgumentException("The response and exception of the request are both Null, please check the request or contact customer service"));
            }
            if (Objects.nonNull(throwable)) {
                this.handleThrowable((Throwable)throwable);
            }
            boolean bl = this.shouldRetry = this.shouldRetry || Objects.nonNull(this.func) && this.func.apply(resp, this.currException) != false;
            if (currRetriesAttempted <= this.maxRetryTimes && this.shouldRetry) {
                int statusCode = this.getStatusCodeFromResult(resp, this.currException);
                RetryContext<Object> context = this.buildContext(resp, this.currException, statusCode, currRetriesAttempted);
                long delayBeforeNextRetry = this.backoffStrategy.computeDelayBeforeNextRetry(context);
                this.printRetryLog(currRetriesAttempted, delayBeforeNextRetry);
                this.reschedule(executor, delayBeforeNextRetry);
            } else if (Objects.nonNull(this.currException)) {
                this.future.completeExceptionally(this.currException);
            } else {
                this.future.complete(resp);
            }
        });
    }

    private void handleThrowable(Throwable throwable) {
        Throwable cause;
        if (CompletionException.class.isAssignableFrom(throwable.getClass()) && SdkException.class.isAssignableFrom((cause = throwable.getCause()).getClass())) {
            this.handleSdkException((SdkException)cause);
        }
        if (SdkException.class.isAssignableFrom(throwable.getClass())) {
            this.handleSdkException((SdkException)throwable);
        }
        if (Objects.isNull(this.currException)) {
            this.currException = new SdkException(throwable.getCause());
        }
    }

    private void handleSdkException(SdkException e) {
        ServiceResponseException temp;
        this.currException = e;
        if (e instanceof ConnectionException) {
            this.shouldRetry = true;
        }
        if (e instanceof ServiceResponseException && ((temp = (ServiceResponseException)e).getHttpStatusCode() == 429 || temp.getHttpStatusCode() >= 500)) {
            this.shouldRetry = true;
        }
    }

    public void schedule() {
        this.executorService.submit(() -> this.perform(this.executorService));
    }

    public void reschedule(ScheduledExecutorService executor, long delay) {
        executor.schedule(() -> this.perform(executor), delay, TimeUnit.MILLISECONDS);
    }

    private static ThreadFactory initNamedThreadFactory() {
        return r -> {
            Thread thread = new Thread(r);
            thread.setName("thread-retry-timer");
            return thread;
        };
    }

    RetryContext<ResT> buildContext(ResT resT, SdkException e, int statusCode, int retriesAttempted) {
        return RetryContext.builder().withLastResponse(resT).withLastException(e).withStatusCode(statusCode).withRetriesAttempted(retriesAttempted).build();
    }

    public int getStatusCodeFromResult(ResT resT, SdkException e) {
        int statusCode = 0;
        if (Objects.nonNull(resT)) {
            try {
                Method getStatusCodeFunc = resT.getClass().getMethod("getHttpStatusCode", new Class[0]);
                getStatusCodeFunc.setAccessible(true);
                statusCode = (Integer)getStatusCodeFunc.invoke(resT, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException noSuchFieldException) {
                throw new SdkException(noSuchFieldException);
            }
        } else if (e instanceof ServiceResponseException) {
            statusCode = ((ServiceResponseException)e).getHttpStatusCode();
        }
        return statusCode;
    }

    public CompletableFuture<ResT> getFuture() {
        return this.future;
    }

    public void setFuture(CompletableFuture<ResT> future) {
        this.future = future;
    }

    public Supplier<CompletableFuture<ResT>> getWorkSupplier() {
        return this.workSupplier;
    }

    public void setWorkSupplier(Supplier<CompletableFuture<ResT>> workSupplier) {
        this.workSupplier = workSupplier;
    }

    public void printRetryLog(int retriesAttempted, long waitBeforeNextRetry) {
        RetryLog.get().info("After waiting for {} milliseconds, the request will retry for the {}th times, and the max retry times is {}.", new Object[]{waitBeforeNextRetry, retriesAttempted, this.maxRetryTimes});
    }

    public static class RetryLog {
        private static final Logger logger = LoggerFactory.getLogger((String)"HuaweiCloud-SDK-Retry");

        public static Logger get() {
            return logger;
        }
    }
}

