/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import jec.EventSearchCriteria;
import jec.ExchangeConnectorFactory;
import jec.ExchangeGeneralException;
import jec.InvalidSearchCriteriaException;
import jec.OREventSearchCriteria;
import jec.b;
import jec.dto.ExchangeContactDTO;
import jec.dto.ExchangeEmailDTO;
import jec.dto.ExchangeEventDTO;
import jec.dto.ExchangeTaskDTO;
import jec.utils.AppLogger;

public class ExchangeConnectorExamples {
    static String _exchangeHost = "exmx";
    static String _applicationUserAccountName = "ehasson";
    static String _applicationUserPassword = "nasich11";
    static String _prefix = "Exchange";
    static String _mailboxName = "ehasson";
    static boolean _useSSL = false;
    static String contactUniqueId = null;
    static String eventUniqueId = null;
    static String taskUniqueId = null;

    public static void main(String[] stringArray) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            String string = null;
            System.out.println("Welcome to JEC example!");
            System.out.println("To use the main default values just press <Enter>");
            System.out.println("");
            System.out.println("Please insert Exchange IP or host name: ");
            try {
                string = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (string != null && !string.equals("")) {
                _exchangeHost = string;
            }
            System.out.println("Exchange Host:" + _exchangeHost);
            System.out.println("");
            System.out.println("Please insert Exchange user name: ");
            try {
                string = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (string != null && !string.equals("")) {
                _applicationUserAccountName = string;
            }
            System.out.println("");
            System.out.println("Application User Account Name:" + _applicationUserAccountName);
            System.out.print("Please insert Exchange password: ");
            try {
                string = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (string != null && !string.equals("")) {
                _applicationUserPassword = string;
            }
            System.out.println("");
            System.out.println("Application User Password:" + _applicationUserPassword);
            System.out.print("Please insert mailbox name (in most cases its the same as the user name): ");
            try {
                string = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (string != null && !string.equals("")) {
                _mailboxName = string;
            }
            System.out.println("");
            System.out.println("Mailbox Name:" + _mailboxName);
            ExchangeConnectorExamples.getContactsExample();
            ExchangeConnectorExamples.addContactExample();
            ExchangeConnectorExamples.updateContactExample();
            ExchangeConnectorExamples.deleteContactExample();
            ExchangeConnectorExamples.addEventExample();
            ExchangeConnectorExamples.authenticateExample();
            ExchangeConnectorExamples.updateEventExample();
            ExchangeConnectorExamples.deleteEventExample();
            ExchangeConnectorExamples.getEventsExample();
            ExchangeConnectorExamples.getEventsFilteredExample();
            ExchangeConnectorExamples.getEmailsExample();
            ExchangeConnectorExamples.getTasksExample();
            ExchangeConnectorExamples.addTaskExample();
            ExchangeConnectorExamples.updateTaskExample();
            ExchangeConnectorExamples.getPublicContactsExample();
        }
        catch (ExchangeGeneralException exchangeGeneralException) {
            exchangeGeneralException.printStackTrace();
        }
    }

    public static void addContactExample() throws ExchangeGeneralException {
        ExchangeConnectorFactory exchangeConnectorFactory = new ExchangeConnectorFactory();
        b b2 = null;
        b2 = exchangeConnectorFactory.createExchangeConnector(_exchangeHost, _applicationUserAccountName, _applicationUserPassword, _prefix, _useSSL, _mailboxName);
        ExchangeContactDTO exchangeContactDTO = new ExchangeContactDTO();
        exchangeContactDTO.setFirstName("guy");
        exchangeContactDTO.setLastName("jeno");
        exchangeContactDTO.setEmail("bushi@tech.com");
        contactUniqueId = "" + System.currentTimeMillis();
        exchangeContactDTO.setUniqueIdForUrl(contactUniqueId);
        System.out.println("Adding contact: " + contactUniqueId);
        b2.addContact(exchangeContactDTO);
        System.out.println("look at the contact list to see that the contact is added.");
    }

    public static void updateContactExample() throws ExchangeGeneralException {
        ExchangeConnectorFactory exchangeConnectorFactory = new ExchangeConnectorFactory();
        b b2 = null;
        b2 = exchangeConnectorFactory.createExchangeConnector(_exchangeHost, _applicationUserAccountName, _applicationUserPassword, _prefix, _useSSL, _mailboxName);
        ArrayList arrayList = b2.getContacts();
        for (int i = 0; i < arrayList.size(); ++i) {
            ExchangeContactDTO exchangeContactDTO = (ExchangeContactDTO)arrayList.get(i);
            String string = exchangeContactDTO.getEmail();
            if (!string.equals("bushi@tech.com")) continue;
            exchangeContactDTO.setFirstName(exchangeContactDTO.getFirstName() + " *changed*");
            b2.updateContact(exchangeContactDTO);
        }
        System.out.println("look at the contact list to see that the contact was updated.");
    }

    public static void deleteContactExample() throws ExchangeGeneralException {
        ExchangeConnectorFactory exchangeConnectorFactory = new ExchangeConnectorFactory();
        b b2 = null;
        b2 = exchangeConnectorFactory.createExchangeConnector(_exchangeHost, _applicationUserAccountName, _applicationUserPassword, _prefix, _useSSL, _mailboxName);
        String string = contactUniqueId;
        try {
            System.out.println("Deleting Contact: " + string);
            b2.deleteContact(string);
        }
        catch (ExchangeGeneralException exchangeGeneralException) {
            exchangeGeneralException.printStackTrace();
        }
    }

    public static void getContactsExample() throws ExchangeGeneralException {
        ExchangeConnectorFactory exchangeConnectorFactory = new ExchangeConnectorFactory();
        b b2 = null;
        b2 = exchangeConnectorFactory.createExchangeConnector(_exchangeHost, _applicationUserAccountName, _applicationUserPassword, _prefix, _useSSL, _mailboxName);
        ArrayList arrayList = b2.getContacts();
        for (int i = 0; i < arrayList.size(); ++i) {
            ExchangeContactDTO exchangeContactDTO = (ExchangeContactDTO)arrayList.get(i);
            System.out.println("contact.getFirstName(): " + exchangeContactDTO.getFirstName());
            System.out.println("contact.getLastName(): " + exchangeContactDTO.getLastName());
        }
    }

    public static void addEventExample() throws ExchangeGeneralException {
        ExchangeConnectorFactory exchangeConnectorFactory = new ExchangeConnectorFactory();
        b b2 = null;
        b2 = exchangeConnectorFactory.createExchangeConnector(_exchangeHost, _applicationUserAccountName, _applicationUserPassword, _prefix, _useSSL, _mailboxName);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        Date date2 = null;
        try {
            date = simpleDateFormat.parse("2007-03-29 17:00:00");
            date2 = simpleDateFormat.parse("2007-03-29 18:00:00");
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        ExchangeEventDTO exchangeEventDTO = new ExchangeEventDTO();
        eventUniqueId = "" + System.currentTimeMillis();
        exchangeEventDTO.setUniqueIdForUrl(eventUniqueId);
        exchangeEventDTO.setSubject("eli test event");
        exchangeEventDTO.setDescription("my test event");
        exchangeEventDTO.setStartDate(date);
        exchangeEventDTO.setEndDate(date2);
        exchangeEventDTO.setImportance(2);
        exchangeEventDTO.setId(eventUniqueId);
        b2.addEvent(exchangeEventDTO);
        System.out.println("look at: " + date + " events to see that the event was added.");
    }

    public static void addEventExample2() throws ExchangeGeneralException {
        ExchangeConnectorFactory exchangeConnectorFactory = new ExchangeConnectorFactory();
        b b2 = null;
        b2 = exchangeConnectorFactory.createExchangeConnector(_exchangeHost, _applicationUserAccountName, _applicationUserPassword, _prefix, _useSSL, _mailboxName, "GMT+03:00");
        Date date = new Date();
        Date date2 = new Date();
        ExchangeEventDTO exchangeEventDTO = new ExchangeEventDTO();
        eventUniqueId = "" + System.currentTimeMillis();
        exchangeEventDTO.setUniqueIdForUrl(eventUniqueId);
        exchangeEventDTO.setSubject("eli test event");
        exchangeEventDTO.setDescription("my test event");
        exchangeEventDTO.setStartDate(date);
        exchangeEventDTO.setEndDate(date2);
        exchangeEventDTO.setId(eventUniqueId);
        b2.addEvent(exchangeEventDTO);
        System.out.println("look at the todays events to see that the event was added.");
    }

    public static void updateEventExample() throws ExchangeGeneralException {
        ExchangeConnectorFactory exchangeConnectorFactory = new ExchangeConnectorFactory();
        b b2 = null;
        b2 = exchangeConnectorFactory.createExchangeConnector(_exchangeHost, _applicationUserAccountName, _applicationUserPassword, _prefix, _useSSL, _mailboxName);
        ExchangeEventDTO exchangeEventDTO = new ExchangeEventDTO();
        exchangeEventDTO.setUniqueIdForUrl(eventUniqueId);
        exchangeEventDTO.setId(eventUniqueId);
        exchangeEventDTO.setDescription("my event2");
        exchangeEventDTO.setStartDate(new Date());
        exchangeEventDTO.setEndDate(new Date());
        exchangeEventDTO.setSubject("eli test2 updated");
        System.out.println("updating event: " + exchangeEventDTO);
        b2.updateEvent(exchangeEventDTO);
    }

    public static void deleteEventExample() throws ExchangeGeneralException {
        ExchangeConnectorFactory exchangeConnectorFactory = new ExchangeConnectorFactory();
        b b2 = null;
        b2 = exchangeConnectorFactory.createExchangeConnector(_exchangeHost, _applicationUserAccountName, _applicationUserPassword, _prefix, _useSSL, _mailboxName);
        String string = eventUniqueId;
        try {
            b2.deleteEvent(string);
            System.out.println("event: " + string + " deleted.");
        }
        catch (ExchangeGeneralException exchangeGeneralException) {
            exchangeGeneralException.printStackTrace();
        }
    }

    public static void deleteEventExample2() throws ExchangeGeneralException {
        ExchangeConnectorFactory exchangeConnectorFactory = new ExchangeConnectorFactory();
        b b2 = null;
        b2 = exchangeConnectorFactory.createExchangeConnector(_exchangeHost, _applicationUserAccountName, _applicationUserPassword, _prefix, _useSSL, _mailboxName);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        Date date2 = null;
        try {
            date = simpleDateFormat.parse("2006-12-5 21:00:00");
            date2 = simpleDateFormat.parse("2006-12-7 21:00:00");
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        System.out.println("getting events from startDate: " + date + " to endDate: " + date2);
        ArrayList arrayList = b2.getEvents(date, date2, 5);
        for (int i = 0; i < arrayList.size(); ++i) {
            System.out.println("event " + i + " subject: " + ((ExchangeEventDTO)arrayList.get(i)).getSubject());
            System.out.println("event " + i + " location: " + ((ExchangeEventDTO)arrayList.get(i)).getLocation());
            AppLogger.getLogger().debug((Object)("event " + i + " location: " + ((ExchangeEventDTO)arrayList.get(i)).getLocation()));
            try {
                if (i != 0) continue;
                System.out.println("trying to delete event: " + ((ExchangeEventDTO)arrayList.get(i)).getUniqueIdForUrl());
                b2.deleteEvent(((ExchangeEventDTO)arrayList.get(i)).getUniqueIdForUrl());
                continue;
            }
            catch (ExchangeGeneralException exchangeGeneralException) {
                exchangeGeneralException.printStackTrace();
            }
        }
    }

    public static void getEventsFilteredExample() throws ExchangeGeneralException {
        ExchangeConnectorFactory exchangeConnectorFactory = new ExchangeConnectorFactory();
        b b2 = null;
        b2 = exchangeConnectorFactory.createExchangeConnector(_exchangeHost, _applicationUserAccountName, _applicationUserPassword, _prefix, _useSSL, _mailboxName, "GMT+2:00");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        Date date2 = null;
        try {
            date = simpleDateFormat.parse("2006-11-24 08:00:00");
            date2 = simpleDateFormat.parse("2006-11-29 21:00:00");
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        System.out.println("getting events from startDate: " + date + " to endDate: " + date2);
        try {
            EventSearchCriteria eventSearchCriteria = new EventSearchCriteria(".*[tT][Hh][Ee].*", ".*", ".*", -1, -1);
            ArrayList arrayList = b2.getEvents(date, date2, eventSearchCriteria);
            for (int i = 0; i < arrayList.size(); ++i) {
                System.out.println("event " + i + " subject: " + ((ExchangeEventDTO)arrayList.get(i)).getSubject());
                System.out.println("event " + i + " location: " + ((ExchangeEventDTO)arrayList.get(i)).getLocation());
                System.out.println("event " + i + " StartDate: " + ((ExchangeEventDTO)arrayList.get(i)).getStartDate());
                System.out.println("event " + i + " EndDate: " + ((ExchangeEventDTO)arrayList.get(i)).getEndDate());
                System.out.println("event " + i + " exchange id: " + ((ExchangeEventDTO)arrayList.get(i)).getUniqueIdForUrl());
                System.out.println("event " + i + " description: " + ((ExchangeEventDTO)arrayList.get(i)).getDescription());
            }
        }
        catch (InvalidSearchCriteriaException invalidSearchCriteriaException) {
            invalidSearchCriteriaException.printStackTrace();
        }
    }

    public static void getEventsExample() throws ExchangeGeneralException {
        ExchangeConnectorFactory exchangeConnectorFactory = new ExchangeConnectorFactory();
        b b2 = null;
        b2 = exchangeConnectorFactory.createExchangeConnector(_exchangeHost, _applicationUserAccountName, _applicationUserPassword, _prefix, _useSSL, _mailboxName);
        b2.authenticate();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        Date date2 = null;
        try {
            date = simpleDateFormat.parse("2007-01-24 21:00:00");
            date2 = simpleDateFormat.parse("2007-02-14 21:00:00");
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        System.out.println("getting events from startDate: " + date + " to endDate: " + date2);
        ArrayList arrayList = b2.getEvents(date, date2, 100);
        for (int i = 0; i < arrayList.size(); ++i) {
            System.out.println("event " + i + " subject: " + ((ExchangeEventDTO)arrayList.get(i)).getSubject());
            System.out.println("event " + i + " location: " + ((ExchangeEventDTO)arrayList.get(i)).getLocation());
            System.out.println("event " + i + " all day event: " + ((ExchangeEventDTO)arrayList.get(i)).getIsAllDayEvent());
            System.out.println("event " + i + " Is Recurrent event: " + ((ExchangeEventDTO)arrayList.get(i)).getIsRecurrent());
        }
    }

    public static void getEventsExample2() throws ExchangeGeneralException {
        ExchangeConnectorFactory exchangeConnectorFactory = new ExchangeConnectorFactory();
        b b2 = null;
        b2 = exchangeConnectorFactory.createExchangeConnector(_exchangeHost, _applicationUserAccountName, _applicationUserPassword, _prefix, _useSSL, _mailboxName);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        Date date2 = null;
        try {
            date = simpleDateFormat.parse("2006-12-21 06:00:00");
            date2 = simpleDateFormat.parse("2006-12-21 21:00:00");
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        System.out.println("getting events from startDate: " + date + " to endDate: " + date2);
        ArrayList arrayList = b2.getEvents(date, date2, 5);
        for (int i = 0; i < arrayList.size(); ++i) {
            System.out.println("event " + i + " subject: " + ((ExchangeEventDTO)arrayList.get(i)).getSubject());
            System.out.println("event " + i + " location: " + ((ExchangeEventDTO)arrayList.get(i)).getLocation());
            System.out.println("event " + i + " StartDate: " + ((ExchangeEventDTO)arrayList.get(i)).getStartDate());
            System.out.println("event " + i + " EndDate: " + ((ExchangeEventDTO)arrayList.get(i)).getEndDate());
            System.out.println("event " + i + " importance (0-> low, 1-> normal, 2->high): " + ((ExchangeEventDTO)arrayList.get(i)).getImportance());
        }
    }

    public static void authenticateExample() throws ExchangeGeneralException {
        ExchangeConnectorFactory exchangeConnectorFactory = new ExchangeConnectorFactory();
        b b2 = null;
        b2 = exchangeConnectorFactory.createExchangeConnector(_exchangeHost, _applicationUserAccountName, _applicationUserPassword, _prefix, _useSSL, _mailboxName);
        b2.authenticate();
        System.out.println("authenticated.");
    }

    public static void getEmailsExample() throws ExchangeGeneralException {
        ExchangeConnectorFactory exchangeConnectorFactory = new ExchangeConnectorFactory();
        b b2 = null;
        b2 = exchangeConnectorFactory.createExchangeConnector(_exchangeHost, _applicationUserAccountName, _applicationUserPassword, _prefix, _useSSL, _mailboxName);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = simpleDateFormat.parse("2007-01-25 06:00:00");
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        HashSet hashSet = null;
        HashSet hashSet2 = null;
        int n = 100;
        ArrayList arrayList = b2.getEmails(date, hashSet, hashSet2, n);
        System.out.println("emailsArrayList.size() : " + arrayList.size());
        if (arrayList.size() > 0) {
            ExchangeEmailDTO exchangeEmailDTO = (ExchangeEmailDTO)arrayList.get(0);
            System.out.println("email1 email1.getSubject(): " + exchangeEmailDTO.getSubject());
        }
    }

    public static void getTasksExample() throws ExchangeGeneralException {
        ExchangeConnectorFactory exchangeConnectorFactory = new ExchangeConnectorFactory();
        b b2 = null;
        b2 = exchangeConnectorFactory.createExchangeConnector(_exchangeHost, _applicationUserAccountName, _applicationUserPassword, _prefix, _useSSL, _mailboxName, "GMT+02:00");
        ArrayList arrayList = b2.getTasks();
        if (arrayList.size() > 0) {
            int n = arrayList.size() < 10 ? arrayList.size() : 10;
            for (int i = 0; i < n; ++i) {
                ExchangeTaskDTO exchangeTaskDTO = (ExchangeTaskDTO)arrayList.get(i);
                System.out.println("============ task " + i + " start =============================");
                System.out.println("task.subject(): " + exchangeTaskDTO.getSubject());
                System.out.println("task.isComplete(): " + exchangeTaskDTO.isCompleted());
                System.out.println("task.getDueDate(): " + exchangeTaskDTO.getDueDate());
                System.out.println("task.getPercentComplete(): " + exchangeTaskDTO.getPercentComplete());
                System.out.println("task.getPriority(): " + exchangeTaskDTO.getPriority());
                System.out.println("task.getFrom(): " + exchangeTaskDTO.getFrom());
                System.out.println("task.getCreationDate(): " + exchangeTaskDTO.getCreationDate());
                System.out.println("task.getLastModifiedDate(): " + exchangeTaskDTO.getLastModifiedDate());
                System.out.println("task.getStatus(): " + exchangeTaskDTO.getStatus());
                System.out.println("task.getUniqueIdForUrl(): " + exchangeTaskDTO.getUniqueIdForUrl());
                System.out.println("============ task " + i + " end =============================");
            }
        } else {
            System.out.println("you dont have tasks.");
        }
    }

    public static void addTaskExample() throws ExchangeGeneralException {
        ExchangeConnectorFactory exchangeConnectorFactory = new ExchangeConnectorFactory();
        b b2 = null;
        b2 = exchangeConnectorFactory.createExchangeConnector(_exchangeHost, _applicationUserAccountName, _applicationUserPassword, _prefix, _useSSL, _mailboxName, "GMT+02:00");
        ExchangeTaskDTO exchangeTaskDTO = new ExchangeTaskDTO();
        exchangeTaskDTO.setSubject("test task");
        exchangeTaskDTO.setTextDescription("test desc");
        exchangeTaskDTO.setPriority("0");
        exchangeTaskDTO.setIsCompleted(true);
        exchangeTaskDTO.setPercentComplete("0");
        exchangeTaskDTO.setStatus("0");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = simpleDateFormat.parse("2007-03-23 18:00:00");
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        exchangeTaskDTO.setDueDate(date);
        Date date2 = null;
        try {
            date2 = simpleDateFormat.parse("2007-03-22 13:00:00");
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        exchangeTaskDTO.setStartDate(date2);
        b2.addTask(exchangeTaskDTO);
        taskUniqueId = exchangeTaskDTO.getUniqueIdForUrl();
        System.out.println("task: " + taskUniqueId + " created.");
    }

    public static void updateTaskFullExample() throws ExchangeGeneralException {
        ExchangeConnectorFactory exchangeConnectorFactory = new ExchangeConnectorFactory();
        b b2 = null;
        b2 = exchangeConnectorFactory.createExchangeConnector(_exchangeHost, _applicationUserAccountName, _applicationUserPassword, _prefix, _useSSL, _mailboxName, "GMT+02:00");
        ArrayList arrayList = b2.getTasks();
        if (arrayList.size() > 0) {
            ExchangeTaskDTO exchangeTaskDTO = (ExchangeTaskDTO)arrayList.get(0);
            System.out.println("task.subject(): " + exchangeTaskDTO.getSubject());
            System.out.println("task.isComplete(): " + exchangeTaskDTO.isCompleted());
            System.out.println("task.getDueDate(): " + exchangeTaskDTO.getDueDate());
            System.out.println("task.getStartDate(): " + exchangeTaskDTO.getStartDate());
            System.out.println("task.getPercentComplete(): " + exchangeTaskDTO.getPercentComplete());
            System.out.println("task.getPriority(): " + exchangeTaskDTO.getPriority());
            System.out.println("task.getStatus(): " + exchangeTaskDTO.getStatus());
            System.out.println("task.getUniqueIdForUrl(): " + exchangeTaskDTO.getUniqueIdForUrl());
            exchangeTaskDTO.setSubject(exchangeTaskDTO.getSubject() + " u");
            exchangeTaskDTO.setTextDescription("bla bla");
            exchangeTaskDTO.setPriority("2");
            exchangeTaskDTO.setIsCompleted(true);
            exchangeTaskDTO.setPercentComplete("1");
            exchangeTaskDTO.setStatus("2");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = null;
            try {
                date = simpleDateFormat.parse("2007-01-16 18:00:00");
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
            exchangeTaskDTO.setDueDate(date);
            Date date2 = null;
            try {
                date2 = simpleDateFormat.parse("2007-01-13 13:00:00");
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
            exchangeTaskDTO.setStartDate(date2);
            b2.updateTask(exchangeTaskDTO);
            System.out.println("task: " + exchangeTaskDTO.getUniqueIdForUrl() + " updated.");
        } else {
            System.out.println("you dont have tasks.");
        }
    }

    public static void updateTaskExample() throws ExchangeGeneralException {
        ExchangeConnectorFactory exchangeConnectorFactory = new ExchangeConnectorFactory();
        b b2 = null;
        b2 = exchangeConnectorFactory.createExchangeConnector(_exchangeHost, _applicationUserAccountName, _applicationUserPassword, _prefix, _useSSL, _mailboxName);
        ExchangeTaskDTO exchangeTaskDTO = new ExchangeTaskDTO();
        exchangeTaskDTO.setUniqueIdForUrl(taskUniqueId);
        exchangeTaskDTO.setSubject("subject updated");
        exchangeTaskDTO.setStatus("2");
        b2.updateTask(exchangeTaskDTO);
        System.out.println("task: " + exchangeTaskDTO.getUniqueIdForUrl() + " updated.");
    }

    public static void getPublicContactsExample() throws ExchangeGeneralException {
        ExchangeConnectorFactory exchangeConnectorFactory = new ExchangeConnectorFactory();
        b b2 = null;
        b2 = exchangeConnectorFactory.createExchangeConnector(_exchangeHost, _applicationUserAccountName, _applicationUserPassword, _prefix, _useSSL, _mailboxName);
        ArrayList arrayList = b2.getPublicContacts();
        for (int i = 0; i < arrayList.size(); ++i) {
            ExchangeContactDTO exchangeContactDTO = (ExchangeContactDTO)arrayList.get(i);
            System.out.println("contact.getFirstName(): " + exchangeContactDTO.getFirstName());
        }
    }

    public static void addPublicContactExample() throws ExchangeGeneralException {
        ExchangeConnectorFactory exchangeConnectorFactory = new ExchangeConnectorFactory();
        b b2 = null;
        b2 = exchangeConnectorFactory.createExchangeConnector(_exchangeHost, _applicationUserAccountName, _applicationUserPassword, _prefix, _useSSL, _mailboxName);
        ExchangeContactDTO exchangeContactDTO = new ExchangeContactDTO();
        exchangeContactDTO.setFirstName("guy");
        exchangeContactDTO.setLastName("jeno");
        exchangeContactDTO.setEmail("bushi@tech.com");
        contactUniqueId = "" + System.currentTimeMillis();
        exchangeContactDTO.setUniqueIdForUrl(contactUniqueId);
        System.out.println("Adding contact: " + contactUniqueId);
        b2.addPublicContact(exchangeContactDTO);
        System.out.println("look at the contact list to see that the contact is added.");
    }

    public static void updatePublicContactExample() throws ExchangeGeneralException {
        ExchangeConnectorFactory exchangeConnectorFactory = new ExchangeConnectorFactory();
        b b2 = null;
        b2 = exchangeConnectorFactory.createExchangeConnector(_exchangeHost, _applicationUserAccountName, _applicationUserPassword, _prefix, _useSSL, _mailboxName);
        ArrayList arrayList = b2.getPublicContacts();
        for (int i = 0; i < arrayList.size(); ++i) {
            ExchangeContactDTO exchangeContactDTO = (ExchangeContactDTO)arrayList.get(i);
            String string = exchangeContactDTO.getEmail();
            if (!string.equals("elitest2@test.com")) continue;
            exchangeContactDTO.setFirstName(exchangeContactDTO.getFirstName() + " *changed*");
            b2.updatePublicContact(exchangeContactDTO);
        }
        System.out.println("look at the contact list to see that the contact was updated.");
    }

    public static void getEventsORFilteredExample() throws ExchangeGeneralException {
        ExchangeConnectorFactory exchangeConnectorFactory = new ExchangeConnectorFactory();
        b b2 = null;
        b2 = exchangeConnectorFactory.createExchangeConnector(_exchangeHost, _applicationUserAccountName, _applicationUserPassword, _prefix, _useSSL, _mailboxName, "GMT+2:00");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        Date date2 = null;
        try {
            date = simpleDateFormat.parse("2007-02-01 08:00:00");
            date2 = simpleDateFormat.parse("2007-02-01 21:00:00");
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        System.out.println("getting events from startDate: " + date + " to endDate: " + date2);
        try {
            OREventSearchCriteria oREventSearchCriteria = new OREventSearchCriteria(".*test.*", ".*test.*", ".*test.*", -1, -1);
            ArrayList arrayList = b2.getEvents(date, date2, oREventSearchCriteria);
            for (int i = 0; i < arrayList.size(); ++i) {
                System.out.println("event " + i + " subject: " + ((ExchangeEventDTO)arrayList.get(i)).getSubject());
                System.out.println("event " + i + " location: " + ((ExchangeEventDTO)arrayList.get(i)).getLocation());
                System.out.println("event " + i + " description: " + ((ExchangeEventDTO)arrayList.get(i)).getDescription());
            }
        }
        catch (InvalidSearchCriteriaException invalidSearchCriteriaException) {
            invalidSearchCriteriaException.printStackTrace();
        }
    }
}

