/*
 * Decompiled with CFR 0.152.
 */
package com.jd.open.api.sdk;

import com.jd.open.api.sdk.JdClient;
import com.jd.open.api.sdk.JdException;
import com.jd.open.api.sdk.internal.parser.Parser;
import com.jd.open.api.sdk.internal.parser.ParserFactory;
import com.jd.open.api.sdk.internal.util.CodecUtil;
import com.jd.open.api.sdk.internal.util.HttpUtil;
import com.jd.open.api.sdk.internal.util.StringUtil;
import com.jd.open.api.sdk.request.JdRequest;
import com.jd.open.api.sdk.request.JdUploadRequest;
import com.jd.open.api.sdk.response.AbstractResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJdClient
implements JdClient {
    public static final String CHARSET_UTF8 = "UTF-8";
    private static final String JSON_PARAM_KEY = "360buy_param_json";
    private static final String OTHER_PARAM_KEY = "other";
    private String serverUrl;
    private String accessToken;
    private int connectTimeout = 0;
    private int readTimeout = 0;
    private String appKey;
    private String fuzz;
    private String appSecret;

    public DefaultJdClient(String serverUrl, String accessToken, String appKey, String appSecret) {
        this.serverUrl = serverUrl;
        this.accessToken = accessToken;
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public DefaultJdClient(String serverUrl, String accessToken, String appKey, String appSecret, String fuzz) {
        this.serverUrl = serverUrl;
        this.accessToken = accessToken;
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.fuzz = fuzz;
    }

    public DefaultJdClient(String serverUrl, String accessToken, String appKey, String appSecret, int connectTimeout, int readTimeout) {
        this(serverUrl, accessToken, appKey, appSecret);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    @Override
    public <T extends AbstractResponse> T execute(JdRequest<T> request) throws Exception {
        String url = this.buildUrl(request);
        HashMap<String, String> params = new HashMap<String, String>();
        String json = request.getAppJsonParams();
        params.put(JSON_PARAM_KEY, json);
        if (request.getOtherParams() != null) {
            params.put(OTHER_PARAM_KEY, request.getOtherParams());
        }
        String rsp = null;
        rsp = request instanceof JdUploadRequest ? HttpUtil.doPost(url, params, ((JdUploadRequest)request).getFileParams(), this.connectTimeout, this.readTimeout) : HttpUtil.doPost(url, params, this.connectTimeout, this.readTimeout);
        T resp = this.parse(rsp, request.getResponseClass(), request.getApiMethod());
        StringBuffer sb = new StringBuffer();
        sb.append(url).append("&").append(JSON_PARAM_KEY).append("=").append(json);
        ((AbstractResponse)resp).setUrl(sb.toString());
        return resp;
    }

    private <T extends AbstractResponse> String buildUrl(JdRequest<T> request) throws Exception {
        Map<String, String> sysParams = request.getSysParams();
        TreeMap<String, String> pmap = new TreeMap<String, String>();
        pmap.put(JSON_PARAM_KEY, request.getAppJsonParams());
        sysParams.put("method", request.getApiMethod());
        sysParams.put("access_token", this.accessToken);
        sysParams.put("app_key", this.appKey);
        if (this.fuzz != null) {
            sysParams.put("jos_result_fuzz", this.fuzz);
        }
        pmap.putAll(sysParams);
        String sign = this.sign(pmap, this.appSecret);
        sysParams.put("sign", sign);
        StringBuilder sb = new StringBuilder(this.serverUrl);
        sb.append("?");
        sb.append(HttpUtil.buildQuery(sysParams, CHARSET_UTF8));
        return sb.toString();
    }

    private <T extends AbstractResponse> T parse(String rsp, Class<T> responseClass, String apiName) throws JdException {
        Parser parser = this.serverUrl.endsWith("json") ? ParserFactory.getJsonParser() : ParserFactory.getXmlParser();
        return parser.parse(rsp, responseClass, apiName);
    }

    private String sign(Map<String, String> pmap, String appSecret) throws Exception {
        StringBuilder sb = new StringBuilder(appSecret);
        for (Map.Entry<String, String> entry : pmap.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (!StringUtil.areNotEmpty(name, value)) continue;
            sb.append(name).append(value);
        }
        sb.append(appSecret);
        String result = CodecUtil.md5(sb.toString());
        return result;
    }
}

