/*
 * Decompiled with CFR 0.152.
 */
package com.jd.open.api.sdk.request.crm;

import com.jd.open.api.sdk.internal.util.JsonUtil;
import com.jd.open.api.sdk.request.AbstractRequest;
import com.jd.open.api.sdk.request.JdRequest;
import com.jd.open.api.sdk.response.crm.CrmCouponSearchResponse;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrmCouponSearchRequest
extends AbstractRequest
implements JdRequest<CrmCouponSearchResponse> {
    private Long couponId;
    private Integer denomination;
    private Date endTime;
    private int currentPage;
    private int pageSize;

    public void setCouponId(Long couponId) {
        this.couponId = couponId;
    }

    public Long getCouponId() {
        return this.couponId;
    }

    public void setDenomination(Integer denomination) {
        this.denomination = denomination;
    }

    public Integer getDenomination() {
        return this.denomination;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public String getApiMethod() {
        return "jingdong.crm.coupon.search";
    }

    @Override
    public String getAppJsonParams() throws IOException {
        TreeMap<String, Object> pmap = new TreeMap<String, Object>();
        pmap.put("coupon_id", this.couponId);
        pmap.put("denomination", this.denomination);
        try {
            if (this.endTime != null) {
                pmap.put("end_time", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.endTime));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pmap.put("current_page", this.currentPage);
        pmap.put("page_size", this.pageSize);
        return JsonUtil.toJson(pmap);
    }

    @Override
    public Class<CrmCouponSearchResponse> getResponseClass() {
        return CrmCouponSearchResponse.class;
    }
}

