/*
 * Decompiled with CFR 0.152.
 */
package com.jd.open.api.sdk.request.etms;

import com.jd.open.api.sdk.internal.util.JsonUtil;
import com.jd.open.api.sdk.request.AbstractRequest;
import com.jd.open.api.sdk.request.JdRequest;
import com.jd.open.api.sdk.response.etms.LdopCenterApiReceivePaymentInfoResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdopCenterApiReceivePaymentInfoRequest
extends AbstractRequest
implements JdRequest<LdopCenterApiReceivePaymentInfoResponse> {
    private String deliveryId;
    private String customerCode;
    private BigDecimal recMoney;
    private BigDecimal receivedMoney;
    private Integer paymentState;
    private Date paymentTime;
    private String payer;

    public void setDeliveryId(String deliveryId) {
        this.deliveryId = deliveryId;
    }

    public String getDeliveryId() {
        return this.deliveryId;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public String getCustomerCode() {
        return this.customerCode;
    }

    public void setRecMoney(BigDecimal recMoney) {
        this.recMoney = recMoney;
    }

    public BigDecimal getRecMoney() {
        return this.recMoney;
    }

    public void setReceivedMoney(BigDecimal receivedMoney) {
        this.receivedMoney = receivedMoney;
    }

    public BigDecimal getReceivedMoney() {
        return this.receivedMoney;
    }

    public void setPaymentState(Integer paymentState) {
        this.paymentState = paymentState;
    }

    public Integer getPaymentState() {
        return this.paymentState;
    }

    public void setPaymentTime(Date paymentTime) {
        this.paymentTime = paymentTime;
    }

    public Date getPaymentTime() {
        return this.paymentTime;
    }

    public void setPayer(String payer) {
        this.payer = payer;
    }

    public String getPayer() {
        return this.payer;
    }

    @Override
    public String getApiMethod() {
        return "jingdong.ldop.center.api.receivePaymentInfo";
    }

    @Override
    public String getAppJsonParams() throws IOException {
        TreeMap<String, Object> pmap = new TreeMap<String, Object>();
        pmap.put("deliveryId", this.deliveryId);
        pmap.put("customerCode", this.customerCode);
        pmap.put("recMoney", this.recMoney);
        pmap.put("receivedMoney", this.receivedMoney);
        pmap.put("paymentState", this.paymentState);
        try {
            if (this.paymentTime != null) {
                pmap.put("paymentTime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.paymentTime));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pmap.put("payer", this.payer);
        return JsonUtil.toJson(pmap);
    }

    @Override
    public Class<LdopCenterApiReceivePaymentInfoResponse> getResponseClass() {
        return LdopCenterApiReceivePaymentInfoResponse.class;
    }
}

