/*
 * Decompiled with CFR 0.152.
 */
package com.jd.security.tdeclient;

import com.jd.open.api.sdk.DefaultJdClient;
import com.jd.open.api.sdk.internal.JSON.JSONMapper;
import com.jd.open.api.sdk.internal.util.StringUtil;
import com.jd.open.api.sdk.request.directional.JosSecretApiReportRequest;
import com.jd.open.api.sdk.response.directional.JosSecretApiReportResponse;
import com.jd.security.tde.util.UtilTools;
import com.jd.security.tdeclient.TDEClient;
import com.jd.security.tdeclient.jmq.ProduceRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpReportLogClient {
    private static final Logger LOGGER = Logger.getLogger(HttpReportLogClient.class.getName());
    private ConcurrentHashMap<Integer, ProduceRequest> reports;
    private String hostinfo;
    private TDEClient parent = null;
    private String env_label = System.getProperty("os.name") + "|" + System.getProperty("os.version") + "|" + System.getProperty("java.version");
    private String serverUrl;
    private String accessToken;
    private String appKey;
    private String appSecret;

    public HttpReportLogClient(TDEClient p, String serverUrl, String accessToken, String appKey, String appSecret) {
        this.reports = new ConcurrentHashMap();
        this.hostinfo = this.getHostInfo();
        this.parent = p;
        this.accessToken = accessToken;
        this.serverUrl = serverUrl;
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public void flush() {
        try {
            LOGGER.fine("JMQ thread checks report cache.");
            this.insertStatisticReport();
            this.sendAllReports();
        }
        catch (Throwable t) {
            LOGGER.severe(UtilTools.extractStackTrace(t));
        }
    }

    private void sendAllReports() {
        for (Map.Entry<Integer, ProduceRequest> entry : this.reports.entrySet()) {
            ProduceRequest singleReport = entry.getValue();
            if (!this.sendReport(singleReport)) continue;
            this.reports.remove(entry.getKey());
        }
        if (this.reports.size() == 0) {
            LOGGER.fine("JMQ flushed all messages.");
        } else {
            LOGGER.fine("JMQ still has " + this.reports.size() + " in its queue.");
        }
    }

    private boolean sendReport(ProduceRequest report) {
        boolean ret = false;
        try {
            LOGGER.fine("MQ Request: " + report);
            JosSecretApiReportResponse res = this.reporterUpload(report);
            if (res != null && res.getServiceCode() == 0) {
                LOGGER.fine("JMQ push reply:" + res.getServiceMsg());
                ret = true;
            } else {
                LOGGER.severe("JMQ push failed.");
            }
        }
        catch (Exception e) {
            LOGGER.severe(e.getLocalizedMessage());
        }
        return ret;
    }

    public JosSecretApiReportResponse reporterUpload(ProduceRequest pr) throws Exception {
        DefaultJdClient jdClient;
        JosSecretApiReportRequest josSecretApiReportRequest = pr.convertToJosSecretApiReportRequest();
        if (this.accessToken != null && this.accessToken.startsWith("_")) {
            String customerUserId = this.accessToken.substring(1, this.accessToken.lastIndexOf("_"));
            if (!StringUtil.isDigits(customerUserId)) {
                throw new IllegalArgumentException("token invalid");
            }
            josSecretApiReportRequest.setCustomerUserId(Long.valueOf(customerUserId));
            jdClient = new DefaultJdClient(this.serverUrl, null, this.appKey, this.appSecret);
        } else {
            jdClient = new DefaultJdClient(this.serverUrl, this.accessToken, this.appKey, this.appSecret);
        }
        return jdClient.execute(josSecretApiReportRequest);
    }

    private String getHostInfo() {
        String ip_addr = null;
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            block2: for (NetworkInterface netint : Collections.list(nets)) {
                if (netint.isLoopback() || !netint.isUp()) continue;
                Enumeration<InetAddress> inetAddresses = netint.getInetAddresses();
                for (InetAddress inetAddress : Collections.list(inetAddresses)) {
                    if (!(inetAddress instanceof Inet4Address)) continue;
                    ip_addr = inetAddress.getHostAddress();
                    break block2;
                }
            }
            if (ip_addr == null) {
                ip_addr = "Unknown host";
            }
        }
        catch (Exception ex) {
            ip_addr = "Unknown host";
            LOGGER.severe(ex.getLocalizedMessage());
        }
        return ip_addr;
    }

    public void insertInitReport() {
        String s = "unknown service";
        if (this.parent != null) {
            s = this.parent.getServiceIdentifier();
        }
        ProduceRequest req = ProduceRequest.getInitRequest(this.accessToken, this.serverUrl, this.hostinfo, s, TDEClient.getSDKVer(), this.env_label);
        this.reports.put(MsgType.INIT.id, req);
    }

    public void insertStatisticReport() {
        String s = "unknown service";
        if (this.parent != null) {
            s = this.parent.getServiceIdentifier();
        }
        long[] stat = null;
        if (this.parent != null) {
            stat = this.parent.getStatistic();
        }
        ProduceRequest req = ProduceRequest.getStatisticRequest(this.accessToken, this.serverUrl, this.hostinfo, s, TDEClient.getSDKVer(), this.env_label, stat);
        LOGGER.fine(JSONMapper.toJSONString(req));
        this.reports.put(MsgType.STATISTIC.id, req);
    }

    public void insertEventReport(int eventcode, String eventDetail) {
        String s = "unknown service";
        if (this.parent != null) {
            s = this.parent.getServiceIdentifier();
        }
        ProduceRequest req = ProduceRequest.getEventRequest(this.accessToken, this.serverUrl, this.hostinfo, s, TDEClient.getSDKVer(), this.env_label, eventcode, eventDetail);
        this.sendReport(req);
    }

    public void insertKeyUpdateEventReport(int eventcode, String eventDetail, int major_key_ver, HashMap<String, Integer> keylist) {
        String s = "unknown service";
        if (this.parent != null) {
            s = this.parent.getServiceIdentifier();
        }
        ProduceRequest req = ProduceRequest.getKPEventRequest(this.accessToken, this.serverUrl, this.hostinfo, s, TDEClient.getSDKVer(), this.env_label, eventcode, eventDetail, major_key_ver, keylist);
        this.sendReport(req);
    }

    public void insertErrReport(int errcode, String detail, String stacktrace, MsgLevel level) {
        String s = "unknown service";
        if (this.parent != null) {
            s = this.parent.getServiceIdentifier();
        }
        String detailLocal = detail == null ? "" : detail;
        ProduceRequest req = ProduceRequest.getErrorRequest(this.accessToken, this.serverUrl, this.hostinfo, s, TDEClient.getSDKVer(), this.env_label, level.id, errcode, detailLocal, stacktrace);
        if (level.equals((Object)MsgLevel.ERROR) || level.equals((Object)MsgLevel.SEVERE)) {
            LOGGER.fine("Send urgent messages.");
            this.sendReport(req);
        } else {
            this.reports.put(errcode, req);
        }
    }

    public void setProductionEnv() {
        try {
            if (System.getProperty("os.name").toLowerCase().contains("linux")) {
                String[] cmd = new String[]{"/bin/sh", "-c", "cat /proc/cpuinfo | grep 'model name' | uniq"};
                BufferedReader reader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(cmd).getInputStream()));
                String cpuinfo = reader.readLine();
                reader.close();
                cpuinfo = "|" + cpuinfo.substring(cpuinfo.indexOf(":") + 1).trim();
                this.env_label = this.env_label + cpuinfo;
            } else if (System.getProperty("os.name").toLowerCase().contains("mac")) {
                String cmd = "sysctl -n machdep.cpu.brand_string";
                BufferedReader reader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(cmd).getInputStream()));
                String cpuinfo = "|" + reader.readLine();
                reader.close();
                this.env_label = this.env_label + cpuinfo;
            } else if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                String line;
                String cmd = "wmic cpu get name";
                BufferedReader reader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(cmd).getInputStream()));
                StringBuffer sb = new StringBuffer();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                reader.close();
                String cpuinfo = "|" + sb.toString().replaceAll("Name", "").replaceAll("\n", "").trim();
                this.env_label = this.env_label + cpuinfo;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MsgLevel {
        INFO(1),
        WARN(2),
        ERROR(3),
        SEVERE(4);

        int id;

        private MsgLevel(int i) {
            this.id = i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MsgType {
        INIT(1),
        EXCEPTION(2),
        STATISTIC(3),
        EVENT(4);

        int id;

        private MsgType(int i) {
            this.id = i;
        }
    }
}

