/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.internal.DeleteObjectsResponse;
import com.qcloud.cos.internal.Unmarshaller;
import com.qcloud.cos.internal.XmlResponsesSaxParser;
import com.qcloud.cos.model.AccessControlList;
import com.qcloud.cos.model.Bucket;
import com.qcloud.cos.model.BucketCrossOriginConfiguration;
import com.qcloud.cos.model.BucketDomainConfiguration;
import com.qcloud.cos.model.BucketIntelligentTierConfiguration;
import com.qcloud.cos.model.BucketLifecycleConfiguration;
import com.qcloud.cos.model.BucketLoggingConfiguration;
import com.qcloud.cos.model.BucketReplicationConfiguration;
import com.qcloud.cos.model.BucketTaggingConfiguration;
import com.qcloud.cos.model.BucketVersioningConfiguration;
import com.qcloud.cos.model.BucketWebsiteConfiguration;
import com.qcloud.cos.model.DeleteBucketInventoryConfigurationResult;
import com.qcloud.cos.model.DeleteObjectTaggingResult;
import com.qcloud.cos.model.GetBucketInventoryConfigurationResult;
import com.qcloud.cos.model.GetObjectTaggingResult;
import com.qcloud.cos.model.InitiateMultipartUploadResult;
import com.qcloud.cos.model.ListBucketInventoryConfigurationsResult;
import com.qcloud.cos.model.MultipartUploadListing;
import com.qcloud.cos.model.ObjectListing;
import com.qcloud.cos.model.PartListing;
import com.qcloud.cos.model.SetBucketInventoryConfigurationResult;
import com.qcloud.cos.model.SetObjectTaggingResult;
import com.qcloud.cos.model.VersionListing;
import com.qcloud.cos.model.ciModel.bucket.DocBucketResponse;
import com.qcloud.cos.model.ciModel.bucket.MediaBucketResponse;
import com.qcloud.cos.model.ciModel.job.DocJobListResponse;
import com.qcloud.cos.model.ciModel.job.DocJobResponse;
import com.qcloud.cos.model.ciModel.job.MediaJobResponse;
import com.qcloud.cos.model.ciModel.job.MediaListJobResponse;
import com.qcloud.cos.model.ciModel.mediaInfo.MediaInfoResponse;
import com.qcloud.cos.model.ciModel.queue.DocListQueueResponse;
import com.qcloud.cos.model.ciModel.queue.MediaListQueueResponse;
import com.qcloud.cos.model.ciModel.queue.MediaQueueResponse;
import com.qcloud.cos.model.ciModel.snapshot.SnapshotResponse;
import com.qcloud.cos.model.ciModel.template.MediaListTemplateResponse;
import com.qcloud.cos.model.ciModel.template.MediaTemplateResponse;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowExecutionResponse;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowExecutionsResponse;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowListResponse;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class Unmarshallers {

    public static final class DescribeDocJobsUnmarshaller
    implements Unmarshaller<DocJobListResponse, InputStream> {
        @Override
        public DocJobListResponse unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseDocJobListResponse(in).getResponse();
        }
    }

    public static final class DescribeDocJobUnmarshaller
    implements Unmarshaller<DocJobResponse, InputStream> {
        @Override
        public DocJobResponse unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseDescribeDocJobResponse(in).getResponse();
        }
    }

    public static final class DocProcessJobUnmarshaller
    implements Unmarshaller<DocJobResponse, InputStream> {
        @Override
        public DocJobResponse unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseDocJobResponse(in).getResponse();
        }
    }

    public static final class WorkflowUnmarshaller
    implements Unmarshaller<MediaWorkflowResponse, InputStream> {
        @Override
        public MediaWorkflowResponse unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseWorkflowResponse(in).getResponse();
        }
    }

    public static final class DocListBucketUnmarshaller
    implements Unmarshaller<DocBucketResponse, InputStream> {
        @Override
        public DocBucketResponse unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseDocListBucketResponse(in).getResponse();
        }
    }

    public static final class ListBucketUnmarshaller
    implements Unmarshaller<MediaBucketResponse, InputStream> {
        @Override
        public MediaBucketResponse unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseListBucketResponse(in).getResponse();
        }
    }

    public static final class JobCreatUnmarshaller
    implements Unmarshaller<MediaJobResponse, InputStream> {
        @Override
        public MediaJobResponse unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseJobCreatResponse(in).getResponse();
        }
    }

    public static final class JobUnmarshaller
    implements Unmarshaller<MediaJobResponse, InputStream> {
        @Override
        public MediaJobResponse unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseMediaJobRespones(in).getResponse();
        }
    }

    public static final class ListJobUnmarshaller
    implements Unmarshaller<MediaListJobResponse, InputStream> {
        @Override
        public MediaListJobResponse unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseMediaJobsRespones(in).getResponse();
        }
    }

    public static final class ListTemplateUnmarshaller
    implements Unmarshaller<MediaListTemplateResponse, InputStream> {
        @Override
        public MediaListTemplateResponse unmarshall(InputStream in) throws IOException {
            return new XmlResponsesSaxParser().parseDescribeMediaTemplatesResponse(in).getResponse();
        }
    }

    public static final class WorkflowExecutionUnmarshaller
    implements Unmarshaller<MediaWorkflowExecutionResponse, InputStream> {
        @Override
        public MediaWorkflowExecutionResponse unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseWorkflowExecutionResponse(in).getResponse();
        }
    }

    public static final class WorkflowListUnmarshaller
    implements Unmarshaller<MediaWorkflowListResponse, InputStream> {
        @Override
        public MediaWorkflowListResponse unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseWorkflowListResponse(in).getResponse();
        }
    }

    public static final class WorkflowExecutionsUnmarshaller
    implements Unmarshaller<MediaWorkflowExecutionsResponse, InputStream> {
        @Override
        public MediaWorkflowExecutionsResponse unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseMediaWorkflowExecutionsResponse(in).getResponse();
        }
    }

    public static final class MediaInfoUnmarshaller
    implements Unmarshaller<MediaInfoResponse, InputStream> {
        @Override
        public MediaInfoResponse unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseGenerateMediainfoResponse(in).getResponse();
        }
    }

    public static final class SnapshotUnmarshaller
    implements Unmarshaller<SnapshotResponse, InputStream> {
        @Override
        public SnapshotResponse unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseSnapshotResponse(in).getResponse();
        }
    }

    public static final class TemplateUnmarshaller
    implements Unmarshaller<MediaTemplateResponse, InputStream> {
        @Override
        public MediaTemplateResponse unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseMediaTemplateResponse(in).getResponse();
        }
    }

    public static final class QueueUnmarshaller
    implements Unmarshaller<MediaQueueResponse, InputStream> {
        @Override
        public MediaQueueResponse unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseUpdateMediaQueueResponse(in).getResponse();
        }
    }

    public static final class DocListQueueUnmarshaller
    implements Unmarshaller<DocListQueueResponse, InputStream> {
        @Override
        public DocListQueueResponse unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseDocListQueueResponse(in).getResponse();
        }
    }

    public static final class ListQueueUnmarshaller
    implements Unmarshaller<MediaListQueueResponse, InputStream> {
        @Override
        public MediaListQueueResponse unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseListQueueResponse(in).getResponse();
        }
    }

    public static final class DeleteObjectTaggingResponseUnmarshaller
    implements Unmarshaller<DeleteObjectTaggingResult, InputStream> {
        @Override
        public DeleteObjectTaggingResult unmarshall(InputStream in) throws Exception {
            return new DeleteObjectTaggingResult();
        }
    }

    public static final class SetObjectTaggingResponseUnmarshaller
    implements Unmarshaller<SetObjectTaggingResult, InputStream> {
        @Override
        public SetObjectTaggingResult unmarshall(InputStream in) throws Exception {
            return new SetObjectTaggingResult();
        }
    }

    public static final class GetBucketIntelligentTierConfigurationsUnmarshaller
    implements Unmarshaller<BucketIntelligentTierConfiguration, InputStream> {
        @Override
        public BucketIntelligentTierConfiguration unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseBucketIntelligentTierConfigurationsResponse(in).getConfiguration();
        }
    }

    public static final class GetObjectTaggingResponseUnmarshaller
    implements Unmarshaller<GetObjectTaggingResult, InputStream> {
        @Override
        public GetObjectTaggingResult unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseObjectTaggingResponse(in).getResult();
        }
    }

    public static final class SetBucketInventoryConfigurationUnmarshaller
    implements Unmarshaller<SetBucketInventoryConfigurationResult, InputStream> {
        @Override
        public SetBucketInventoryConfigurationResult unmarshall(InputStream in) throws Exception {
            return new SetBucketInventoryConfigurationResult();
        }
    }

    public static final class DeleteBucketInventoryConfigurationUnmarshaller
    implements Unmarshaller<DeleteBucketInventoryConfigurationResult, InputStream> {
        @Override
        public DeleteBucketInventoryConfigurationResult unmarshall(InputStream in) throws Exception {
            return new DeleteBucketInventoryConfigurationResult();
        }
    }

    public static final class ListBucketInventoryConfigurationsUnmarshaller
    implements Unmarshaller<ListBucketInventoryConfigurationsResult, InputStream> {
        @Override
        public ListBucketInventoryConfigurationsResult unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseBucketListInventoryConfigurationsResponse(in).getResult();
        }
    }

    public static final class GetBucketInventoryConfigurationUnmarshaller
    implements Unmarshaller<GetBucketInventoryConfigurationResult, InputStream> {
        @Override
        public GetBucketInventoryConfigurationResult unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseGetBucketInventoryConfigurationResponse(in).getResult();
        }
    }

    public static final class BucketLoggingConfigurationnmarshaller
    implements Unmarshaller<BucketLoggingConfiguration, InputStream> {
        @Override
        public BucketLoggingConfiguration unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseLoggingStatusResponse(in).getBucketLoggingConfiguration();
        }
    }

    public static final class BucketWebsiteConfigurationUnmarshaller
    implements Unmarshaller<BucketWebsiteConfiguration, InputStream> {
        @Override
        public BucketWebsiteConfiguration unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseWebsiteConfigurationResponse(in).getConfiguration();
        }
    }

    public static final class BucketReplicationConfigurationUnmarshaller
    implements Unmarshaller<BucketReplicationConfiguration, InputStream> {
        @Override
        public BucketReplicationConfiguration unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseReplicationConfigurationResponse(in).getConfiguration();
        }
    }

    public static final class BucketDomainConfigurationUnmarshaller
    implements Unmarshaller<BucketDomainConfiguration, InputStream> {
        @Override
        public BucketDomainConfiguration unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseBucketDomainConfigurationResponse(in).getConfiguration();
        }
    }

    public static final class BucketCrossOriginConfigurationUnmarshaller
    implements Unmarshaller<BucketCrossOriginConfiguration, InputStream> {
        @Override
        public BucketCrossOriginConfiguration unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseBucketCrossOriginConfigurationResponse(in).getConfiguration();
        }
    }

    public static final class BucketLifecycleConfigurationUnmarshaller
    implements Unmarshaller<BucketLifecycleConfiguration, InputStream> {
        @Override
        public BucketLifecycleConfiguration unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseBucketLifecycleConfigurationResponse(in).getConfiguration();
        }
    }

    public static final class DeleteObjectsResultUnmarshaller
    implements Unmarshaller<DeleteObjectsResponse, InputStream> {
        @Override
        public DeleteObjectsResponse unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseDeletedObjectsResult(in).getDeleteObjectResult();
        }
    }

    public static final class ListPartsResultUnmarshaller
    implements Unmarshaller<PartListing, InputStream> {
        @Override
        public PartListing unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseListPartsResponse(in).getListPartsResult();
        }
    }

    public static final class ListMultipartUploadsResultUnmarshaller
    implements Unmarshaller<MultipartUploadListing, InputStream> {
        @Override
        public MultipartUploadListing unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseListMultipartUploadsResponse(in).getListMultipartUploadsResult();
        }
    }

    public static final class InitiateMultipartUploadResultUnmarshaller
    implements Unmarshaller<InitiateMultipartUploadResult, InputStream> {
        @Override
        public InitiateMultipartUploadResult unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseInitiateMultipartUploadResponse(in).getInitiateMultipartUploadResult();
        }
    }

    public static final class CompleteMultipartUploadResultUnmarshaller
    implements Unmarshaller<XmlResponsesSaxParser.CompleteMultipartUploadHandler, InputStream> {
        @Override
        public XmlResponsesSaxParser.CompleteMultipartUploadHandler unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseCompleteMultipartUploadResponse(in);
        }
    }

    public static final class CopyObjectUnmarshaller
    implements Unmarshaller<XmlResponsesSaxParser.CopyObjectResultHandler, InputStream> {
        @Override
        public XmlResponsesSaxParser.CopyObjectResultHandler unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseCopyObjectResponse(in);
        }
    }

    public static final class InputStreamUnmarshaller
    implements Unmarshaller<InputStream, InputStream> {
        @Override
        public InputStream unmarshall(InputStream in) throws Exception {
            return in;
        }
    }

    public static final class BucketTaggingConfigurationUnmarshaller
    implements Unmarshaller<BucketTaggingConfiguration, InputStream> {
        @Override
        public BucketTaggingConfiguration unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseTaggingConfigurationResponse(in).getConfiguration();
        }
    }

    public static final class BucketVersioningConfigurationUnmarshaller
    implements Unmarshaller<BucketVersioningConfiguration, InputStream> {
        @Override
        public BucketVersioningConfiguration unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseVersioningConfigurationResponse(in).getConfiguration();
        }
    }

    public static final class BucketLocationUnmarshaller
    implements Unmarshaller<String, InputStream> {
        @Override
        public String unmarshall(InputStream in) throws Exception {
            String location = new XmlResponsesSaxParser().parseBucketLocationResponse(in);
            if (location == null) {
                location = "Unknown Region";
            }
            return location;
        }
    }

    public static final class AccessControlListUnmarshaller
    implements Unmarshaller<AccessControlList, InputStream> {
        @Override
        public AccessControlList unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseAccessControlListResponse(in).getAccessControlList();
        }
    }

    public static final class VersionListUnmarshaller
    implements Unmarshaller<VersionListing, InputStream> {
        private final boolean shouldSDKDecodeResponse;

        public VersionListUnmarshaller(boolean shouldSDKDecodeResponse) {
            this.shouldSDKDecodeResponse = shouldSDKDecodeResponse;
        }

        @Override
        public VersionListing unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseListVersionsResponse(in, this.shouldSDKDecodeResponse).getListing();
        }
    }

    public static final class ListObjectsUnmarshaller
    implements Unmarshaller<ObjectListing, InputStream> {
        private final boolean shouldSDKDecodeResponse;

        public ListObjectsUnmarshaller(boolean shouldSDKDecodeResponse) {
            this.shouldSDKDecodeResponse = shouldSDKDecodeResponse;
        }

        @Override
        public ObjectListing unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseListBucketObjectsResponse(in, this.shouldSDKDecodeResponse).getObjectListing();
        }
    }

    public static final class ListBucketsUnmarshaller
    implements Unmarshaller<List<Bucket>, InputStream> {
        @Override
        public List<Bucket> unmarshall(InputStream in) throws Exception {
            return new XmlResponsesSaxParser().parseListMyBucketsResponse(in).getBuckets();
        }
    }
}

