/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.filters.heuristics;

import de.l3s.boilerpipe.BoilerpipeFilter;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public final class AddPrecedingLabelsFilter
implements BoilerpipeFilter {
    public static final AddPrecedingLabelsFilter INSTANCE = new AddPrecedingLabelsFilter("");
    public static final AddPrecedingLabelsFilter INSTANCE_PRE = new AddPrecedingLabelsFilter("^");
    private final String labelPrefix;

    public AddPrecedingLabelsFilter(String labelPrefix) {
        this.labelPrefix = labelPrefix;
    }

    @Override
    public boolean process(TextDocument doc) throws BoilerpipeProcessingException {
        List<TextBlock> textBlocks = doc.getTextBlocks();
        if (textBlocks.size() < 2) {
            return false;
        }
        boolean changes = false;
        int remaining = textBlocks.size();
        TextBlock blockBelow = null;
        ListIterator<TextBlock> it = textBlocks.listIterator(textBlocks.size());
        while (it.hasPrevious()) {
            if (--remaining <= 0) break;
            if (blockBelow == null) {
                blockBelow = it.previous();
                continue;
            }
            TextBlock block = it.previous();
            Set<String> labels = block.getLabels();
            if (labels != null && !labels.isEmpty()) {
                for (String l : labels) {
                    blockBelow.addLabel(String.valueOf(this.labelPrefix) + l);
                }
                changes = true;
            }
            blockBelow = block;
        }
        return changes;
    }
}

