/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.sax;

import de.l3s.boilerpipe.labels.LabelAction;
import de.l3s.boilerpipe.sax.BoilerpipeHTMLContentHandler;
import de.l3s.boilerpipe.sax.TagAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class MarkupTagAction
implements TagAction {
    private final boolean isBlockLevel;
    private LinkedList<List<String>> labelStack = new LinkedList();
    private static final Pattern PAT_NUM = Pattern.compile("[0-9]+");

    public MarkupTagAction(boolean isBlockLevel) {
        this.isBlockLevel = isBlockLevel;
    }

    @Override
    public boolean start(BoilerpipeHTMLContentHandler instance, String localName, String qName, Attributes atts) throws SAXException {
        String id;
        ArrayList<String> labels = new ArrayList<String>(5);
        labels.add("<" + localName);
        String classVal = atts.getValue("class");
        if (classVal != null && classVal.length() > 0) {
            classVal = PAT_NUM.matcher(classVal).replaceAll("#");
            classVal = classVal.trim();
            String[] vals = classVal.split("[ ]+");
            labels.add("<." + classVal.replace(' ', '.'));
            if (vals.length > 1) {
                String[] stringArray = vals;
                int n = vals.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    labels.add("<." + s);
                    ++n2;
                }
            }
        }
        if ((id = atts.getValue("id")) != null && id.length() > 0) {
            id = PAT_NUM.matcher(id).replaceAll("#");
            labels.add("<#" + id);
        }
        Set<String> ancestors = this.getAncestorLabels();
        ArrayList<String> labelsWithAncestors = new ArrayList<String>((ancestors.size() + 1) * labels.size());
        for (String l : labels) {
            for (String an : ancestors) {
                labelsWithAncestors.add(an);
                labelsWithAncestors.add(String.valueOf(an) + " " + l);
            }
            labelsWithAncestors.add(l);
        }
        instance.addLabelAction(new LabelAction(labelsWithAncestors.toArray(new String[labelsWithAncestors.size()])));
        this.labelStack.add(labels);
        return this.isBlockLevel;
    }

    @Override
    public boolean end(BoilerpipeHTMLContentHandler instance, String localName, String qName) throws SAXException {
        this.labelStack.removeLast();
        return this.isBlockLevel;
    }

    @Override
    public boolean changesTagLevel() {
        return this.isBlockLevel;
    }

    private Set<String> getAncestorLabels() {
        HashSet<String> set = new HashSet<String>();
        for (List list : this.labelStack) {
            if (list == null) continue;
            set.addAll(list);
        }
        return set;
    }
}

