/*
 * Decompiled with CFR 0.152.
 */
package com.xuxueli.executor.sample.frameless.config;

import com.xuxueli.executor.sample.frameless.jobhandler.CommandJobHandler;
import com.xuxueli.executor.sample.frameless.jobhandler.DemoJobHandler;
import com.xuxueli.executor.sample.frameless.jobhandler.HttpJobHandler;
import com.xuxueli.executor.sample.frameless.jobhandler.ShardingJobHandler;
import com.xxl.job.core.executor.XxlJobExecutor;
import com.xxl.job.core.handler.IJobHandler;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameLessXxlJobConfig {
    private static Logger logger = LoggerFactory.getLogger(FrameLessXxlJobConfig.class);
    private static FrameLessXxlJobConfig instance = new FrameLessXxlJobConfig();
    private XxlJobExecutor xxlJobExecutor = null;

    public static FrameLessXxlJobConfig getInstance() {
        return instance;
    }

    public void initXxlJobExecutor() {
        XxlJobExecutor.registJobHandler((String)"demoJobHandler", (IJobHandler)new DemoJobHandler());
        XxlJobExecutor.registJobHandler((String)"shardingJobHandler", (IJobHandler)new ShardingJobHandler());
        XxlJobExecutor.registJobHandler((String)"httpJobHandler", (IJobHandler)new HttpJobHandler());
        XxlJobExecutor.registJobHandler((String)"commandJobHandler", (IJobHandler)new CommandJobHandler());
        Properties xxlJobProp = FrameLessXxlJobConfig.loadProperties("xxl-job-executor.properties");
        this.xxlJobExecutor = new XxlJobExecutor();
        this.xxlJobExecutor.setAdminAddresses(xxlJobProp.getProperty("xxl.job.admin.addresses"));
        this.xxlJobExecutor.setAppName(xxlJobProp.getProperty("xxl.job.executor.appname"));
        this.xxlJobExecutor.setIp(xxlJobProp.getProperty("xxl.job.executor.ip"));
        this.xxlJobExecutor.setPort(Integer.valueOf(xxlJobProp.getProperty("xxl.job.executor.port")).intValue());
        this.xxlJobExecutor.setAccessToken(xxlJobProp.getProperty("xxl.job.accessToken"));
        this.xxlJobExecutor.setLogPath(xxlJobProp.getProperty("xxl.job.executor.logpath"));
        this.xxlJobExecutor.setLogRetentionDays(Integer.valueOf(xxlJobProp.getProperty("xxl.job.executor.logretentiondays")).intValue());
        try {
            this.xxlJobExecutor.start();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void destoryXxlJobExecutor() {
        if (this.xxlJobExecutor != null) {
            this.xxlJobExecutor.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String propertyFileName) {
        InputStreamReader in = null;
        try {
            ClassLoader loder = Thread.currentThread().getContextClassLoader();
            in = new InputStreamReader(loder.getResourceAsStream(propertyFileName), "UTF-8");
            if (in != null) {
                Properties prop = new Properties();
                prop.load(in);
                Properties properties = prop;
                return properties;
            }
        }
        catch (IOException e) {
            logger.error("load {} error!", (Object)propertyFileName);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error("close {} error!", (Object)propertyFileName);
                }
            }
        }
        return null;
    }
}

