/*
 * Decompiled with CFR 0.152.
 */
package com.youzan.cloud.open.sdk.core.client.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.youzan.cloud.open.sdk.api.API;
import com.youzan.cloud.open.sdk.common.constant.OAuthEnum;
import com.youzan.cloud.open.sdk.common.exception.SDKException;
import com.youzan.cloud.open.sdk.common.util.CheckUtils;
import com.youzan.cloud.open.sdk.core.HttpConfig;
import com.youzan.cloud.open.sdk.core.client.auth.Auth;
import com.youzan.cloud.open.sdk.core.client.core.YouZanClient;
import com.youzan.cloud.open.sdk.core.client.executor.ExecuteFactory;
import com.youzan.cloud.open.sdk.core.client.executor.Executor;
import com.youzan.cloud.open.sdk.core.client.http.DefaultHttpClient;
import com.youzan.cloud.open.sdk.core.client.http.HttpClient;
import com.youzan.cloud.open.sdk.core.oauth.model.OAuthToken;
import com.youzan.cloud.open.sdk.core.oauth.token.TokenHandler;
import com.youzan.cloud.open.sdk.core.oauth.token.TokenHandlerFactory;
import com.youzan.cloud.open.sdk.core.oauth.token.TokenParameter;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DefaultYZClient
implements YouZanClient {
    private HttpClient httpClient;

    public DefaultYZClient() {
        this.httpClient = new DefaultHttpClient(HttpConfig.builder().build());
    }

    public DefaultYZClient(HttpConfig httpConfig) {
        this.httpClient = httpConfig == null ? new DefaultHttpClient(HttpConfig.builder().build()) : new DefaultHttpClient(httpConfig);
    }

    @Override
    public <T> T invoke(API api, Auth auth, Class<T> clazz) throws SDKException {
        String body = this.getResponseBody(api, auth);
        if (StringUtils.isNotEmpty((CharSequence)body)) {
            return (T)JSON.parseObject((String)body, clazz);
        }
        return null;
    }

    @Override
    public <T> T invoke(API api, Auth auth, TypeReference<T> type) throws SDKException {
        String body = this.getResponseBody(api, auth);
        if (body == null || StringUtils.isNotEmpty((CharSequence)body)) {
            return null;
        }
        return (T)JSON.parseObject((String)body, type, (Feature[])new Feature[0]);
    }

    private String getResponseBody(API api, Auth auth) throws SDKException {
        this.check(Objects.requireNonNull(api), Objects.requireNonNull(auth));
        Executor executor = ExecuteFactory.getExecutor(api.getOAuthType());
        return executor.execute(this.httpClient, api, auth);
    }

    @Override
    public String invoke(API api, Auth auth) throws SDKException {
        return this.getResponseBody(api, auth);
    }

    @Override
    public OAuthToken getOAuthToken(TokenParameter tokenParameter) throws SDKException {
        CheckUtils.checkArgument((tokenParameter != null ? 1 : 0) != 0, (OAuthEnum.ErrorMessage)OAuthEnum.ErrorMessage.PARAM_ERROR, (String)"tokenParameter can not be null");
        TokenHandler tokenHandler = TokenHandlerFactory.getTokenHandler(OAuthEnum.TokenType.valueOf((String)Objects.requireNonNull(tokenParameter).getAuthorizeType()));
        return tokenHandler.getToken(this.httpClient, tokenParameter);
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }

    private void check(API api, Auth auth) throws SDKException {
        CheckUtils.checkArgument((api != null ? 1 : 0) != 0, (OAuthEnum.ErrorMessage)OAuthEnum.ErrorMessage.PARAM_ERROR, (String)"api can not be null");
        CheckUtils.checkArgument((auth != null ? 1 : 0) != 0, (OAuthEnum.ErrorMessage)OAuthEnum.ErrorMessage.PARAM_ERROR, (String)"auth can not be null");
        CheckUtils.checkArgument((boolean)Objects.requireNonNull(auth).getType().equals((Object)Objects.requireNonNull(api).getOAuthType()), (OAuthEnum.ErrorMessage)OAuthEnum.ErrorMessage.PARAM_ERROR, (String)"\u63a5\u53e3\u8981\u6c42\u6388\u6743\u7c7b\u578b\u4e0e\u6388\u6743\u51ed\u8bc1\u7c7b\u578b\u4e0d\u5339\u914d");
    }
}

