/*
 * Decompiled with CFR 0.152.
 */
package com.youzan.cloud.open.sdk.core.client.http;

import com.youzan.cloud.open.sdk.common.constant.OAuthEnum;
import com.youzan.cloud.open.sdk.common.exception.SDKException;
import com.youzan.cloud.open.sdk.core.HttpConfig;
import com.youzan.cloud.open.sdk.core.client.http.HttpClient;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class DefaultHttpClient
implements HttpClient {
    private OkHttpClient okHttpClient = null;
    private HttpConfig httpConfig;
    private static final TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }};

    public DefaultHttpClient(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
        this.init();
    }

    private void init() {
        OkHttpClient.Builder builder;
        HttpConfig httpConfig = this.getHttpConfig();
        if (httpConfig.getBuilder() != null) {
            builder = httpConfig.getBuilder();
        } else {
            builder = new OkHttpClient.Builder();
            builder.proxy(httpConfig.getProxy());
            builder.connectTimeout(httpConfig.getConnectTimeout().longValue(), TimeUnit.SECONDS);
            for (Interceptor interceptor : httpConfig.getInterceptors()) {
                builder.addInterceptor(interceptor);
            }
        }
        SSLContext trustAllSslContext = null;
        try {
            trustAllSslContext = SSLContext.getInstance("SSL");
            trustAllSslContext.init(null, trustAllCerts, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException interceptor) {
            // empty catch block
        }
        SSLSocketFactory trustAllSslSocketFactory = Objects.requireNonNull(trustAllSslContext).getSocketFactory();
        builder.sslSocketFactory(trustAllSslSocketFactory, (X509TrustManager)trustAllCerts[0]).hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        });
        this.okHttpClient = builder.build();
    }

    @Override
    public HttpConfig getHttpConfig() {
        if (this.httpConfig == null) {
            return HttpConfig.builder().build();
        }
        return this.httpConfig;
    }

    @Override
    public Response send(Request request) throws SDKException {
        try {
            return this.okHttpClient.newCall(request).execute();
        }
        catch (IOException e) {
            throw new SDKException((Exception)e, OAuthEnum.ErrorMessage.IO_ERROR, e.getMessage());
        }
    }
}

