/*
 * Decompiled with CFR 0.152.
 */
package com.youzan.cloud.open.sdk.core.oauth.token;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.youzan.cloud.open.sdk.common.constant.OAuthEnum;
import com.youzan.cloud.open.sdk.common.exception.SDKException;
import com.youzan.cloud.open.sdk.core.client.http.HttpClient;
import com.youzan.cloud.open.sdk.core.oauth.model.OAuthResult;
import com.youzan.cloud.open.sdk.core.oauth.model.OAuthToken;
import com.youzan.cloud.open.sdk.core.oauth.token.TokenHandler;
import com.youzan.cloud.open.sdk.core.oauth.token.TokenParameter;
import java.io.IOException;
import java.util.Objects;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public abstract class AbstractTokenHandler
implements TokenHandler {
    private static final String OAUTH_PATH = "/auth/token";

    @Override
    public OAuthToken getToken(HttpClient httpClient, TokenParameter tokenParameter) throws SDKException {
        String requestBody = JSON.toJSONString((Object)tokenParameter);
        Headers headers = Headers.of(httpClient.getHttpConfig().getCommonHeaders());
        Request request = new Request.Builder().headers(headers).url(httpClient.getHttpConfig().getTokenHost() + OAUTH_PATH).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)requestBody)).build();
        Response response = httpClient.send(request);
        if (response.isSuccessful()) {
            String bodyString;
            try {
                bodyString = Objects.requireNonNull(response.body()).string();
            }
            catch (IOException e) {
                throw new SDKException((Exception)e, OAuthEnum.ErrorMessage.IO_ERROR, e.getMessage());
            }
            OAuthResult oAuthResult = (OAuthResult)JSON.parseObject((String)bodyString, (TypeReference)new TypeReference<OAuthResult<OAuthToken>>(){}, (Feature[])new Feature[0]);
            if (oAuthResult.getSuccess().booleanValue()) {
                return (OAuthToken)oAuthResult.getData();
            }
            throw new SDKException(oAuthResult.getCode(), oAuthResult.getMessage());
        }
        throw new SDKException(Integer.valueOf(response.code()), response.message());
    }
}

