/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.chinayanghe;

import com.qingstor.sdk.chinayanghe.QsPutObjectRequest;
import com.qingstor.sdk.config.EvnContext;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.model.OutputModel;
import com.qingstor.sdk.service.Bucket;
import com.qingstor.sdk.service.QingStor;

public class QssObjectUtils {
    public static OutputModel putObject(QsPutObjectRequest putObjectRequest) {
        OutputModel ret = null;
        try {
            if (putObjectRequest == null || putObjectRequest.getKey() == null || "".equals(putObjectRequest.getKey())) {
                ret = new OutputModel();
                ret.setStatueCode(99999);
                ret.setMessage("PARAM INVALIDATE!");
                return ret;
            }
            EvnContext evnContext = new EvnContext();
            QingStor storService = new QingStor(evnContext, EvnContext.getZone());
            Bucket bucket = storService.getBucket(putObjectRequest.getBucket(), EvnContext.getZone());
            Bucket.PutObjectInput input = new Bucket.PutObjectInput();
            if (putObjectRequest.getInputStream() != null) {
                input.setBodyInputStream(putObjectRequest.getInputStream());
                input.setContentLength(Long.valueOf(putObjectRequest.getInputStream().available()));
                input.setContentType(putObjectRequest.getHttpContentType());
            } else if (putObjectRequest.getFile() != null) {
                input.setBodyInputFile(putObjectRequest.getFile());
                input.setContentType(putObjectRequest.getHttpContentType());
                input.setContentLength(putObjectRequest.getFile().length());
            } else {
                ret = new OutputModel();
                ret.setStatueCode(99999);
                ret.setMessage("PUT OBJECT IS EMPTY!");
                return ret;
            }
            ret = bucket.putObject(putObjectRequest.getKey(), input);
        }
        catch (Exception e) {
            e.printStackTrace();
            ret = new OutputModel();
            ret.setStatueCode(99999);
            ret.setMessage("PUT OBJECT ERROR!");
            return ret;
        }
        return ret;
    }

    public static String getQssResourceUrL(String bucketName, String key) {
        new EvnContext();
        return String.format("%s/%s/%s", EvnContext.getResouceUri(), bucketName, key);
    }

    public static OutputModel createBucket(String bucketName, Bucket.PutBucketACLInput acl) throws QSException {
        EvnContext evnContext = new EvnContext();
        QingStor storService = new QingStor(evnContext, EvnContext.getZone());
        Bucket bucket = storService.getBucket(bucketName, EvnContext.getZone());
        bucket.putACL(acl);
        return bucket.put();
    }

    public static OutputModel deletObjectFromBucket(String bucketName, String objectName) throws QSException {
        EvnContext evnContext = new EvnContext();
        QingStor storService = new QingStor(evnContext, EvnContext.getZone());
        Bucket bucket = storService.getBucket(bucketName, EvnContext.getZone());
        return bucket.deleteObject(objectName);
    }
}

