/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.request;

import com.qingstor.sdk.config.EvnContext;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.model.OutputModel;
import com.qingstor.sdk.model.RequestInputModel;
import com.qingstor.sdk.request.QSBuilder;
import com.qingstor.sdk.request.QSOkHttpRequestClient;
import com.qingstor.sdk.request.ResponseCallBack;
import com.qingstor.sdk.utils.QSLoggerUtil;
import com.qingstor.sdk.utils.QSParamInvokeUtil;
import com.qingstor.sdk.utils.QSStringUtil;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Request;

public class RequestHandler {
    private static Logger logger = QSLoggerUtil.setLoggerHanlder(RequestHandler.class.getName());
    private Map contextParam;
    private RequestInputModel paramBean;
    private Class outputClass;
    private ResponseCallBack asyncCallback;
    private QSBuilder builder;

    public RequestHandler(Map context, RequestInputModel paramBean, Class outputClass) throws QSException {
        this.contextParam = context;
        this.paramBean = paramBean;
        this.outputClass = outputClass;
        this.builder = new QSBuilder(context, paramBean);
    }

    public RequestHandler(Map context, RequestInputModel paramBean, ResponseCallBack asyncCallback) throws QSException {
        this.contextParam = context;
        this.paramBean = paramBean;
        this.asyncCallback = asyncCallback;
        this.builder = new QSBuilder(context, paramBean);
    }

    public void sendAsync() throws QSException {
        String validate = this.check();
        if (!QSStringUtil.isEmpty(validate)) {
            OutputModel out = QSParamInvokeUtil.getOutputModel(this.asyncCallback);
            QSOkHttpRequestClient.fillResponseCallbackModel(10000, validate, out);
            this.asyncCallback.onAPIResponse(out);
        } else {
            EvnContext evnContext = (EvnContext)this.contextParam.get("evnContext");
            Request request = this.builder.getRequest();
            QSOkHttpRequestClient.getInstance().requestActionAsync(request, evnContext.isSafeOkHttp(), this.asyncCallback);
        }
    }

    public OutputModel send() throws QSException {
        String validate = this.check();
        if (!QSStringUtil.isEmpty(validate)) {
            try {
                OutputModel model = (OutputModel)this.outputClass.newInstance();
                QSOkHttpRequestClient.fillResponseCallbackModel(10000, validate, model);
                return model;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage());
                throw new QSException(e.getMessage());
            }
        }
        EvnContext evnContext = (EvnContext)this.contextParam.get("evnContext");
        Request request = this.builder.getRequest();
        return QSOkHttpRequestClient.getInstance().requestAction(request, evnContext.isSafeOkHttp(), this.outputClass);
    }

    public String getStringToSignature() throws QSException {
        return this.builder.getStringToSignature();
    }

    public void setSignature(String accessKey, String signature) throws QSException {
        this.builder.setSignature(accessKey, signature);
    }

    public String getExpiresRequestUrl() throws QSException {
        return this.builder.getExpiresRequestUrl();
    }

    public String check() {
        String validate = this.paramBean != null ? this.paramBean.validateParam() : "";
        EvnContext evnContext = (EvnContext)this.contextParam.get("evnContext");
        String evnValidate = evnContext.validateParam();
        if (!QSStringUtil.isEmpty(validate) || !QSStringUtil.isEmpty(evnValidate)) {
            if (QSStringUtil.isEmpty(validate)) {
                validate = evnValidate;
            }
            return validate;
        }
        return null;
    }

    public QSBuilder getBuilder() {
        return this.builder;
    }
}

