/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.config;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.config.CommonMapper;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class BaseServiceImpl<M extends CommonMapper<T>, T>
extends ServiceImpl<M, T> {
    private static final int BATCH_SIZE = 1000;

    @Transactional(rollbackFor={Exception.class})
    public boolean fastSaveBatch(List<T> list, int batchSize) {
        if (CollectionUtils.isEmpty(list)) {
            return true;
        }
        int n = batchSize = batchSize < 1 ? 1000 : batchSize;
        if (list.size() <= batchSize) {
            return this.retBool(((CommonMapper)this.baseMapper).insertBatchSomeColumn(list));
        }
        int fromIdx = 0;
        int endIdx = batchSize;
        while (true) {
            if (endIdx > list.size()) {
                endIdx = list.size();
            }
            ((CommonMapper)this.baseMapper).insertBatchSomeColumn(list.subList(fromIdx, endIdx));
            if (endIdx == list.size()) {
                return true;
            }
            fromIdx += batchSize;
            endIdx += batchSize;
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean fastSaveBatch(List<T> list) {
        return this.fastSaveBatch(list, 1000);
    }

    public boolean updateAllColById(T t) {
        return this.retBool(((CommonMapper)this.baseMapper).alwaysUpdateSomeColumnById(t));
    }
}

