/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.config;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.time.LocalDateTime;
import org.apache.ibatis.reflection.MetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnMissingBean(name={"operatorInterceptorExtend"})
public class OperatorInterceptor
implements MetaObjectHandler {
    private static final Logger log = LoggerFactory.getLogger(OperatorInterceptor.class);

    public void insertFill(MetaObject metaObject) {
        Object enableStatus;
        log.debug("\u65b0\u589e\u81ea\u52a8\u586b\u5145\u503c");
        String nowDate = DateUtil.formatDate();
        String nowDatehs = DateUtil.formatShortTime();
        UserRedis user = UserUtils.getUser();
        this.setFieldValByName("createDate", nowDate, metaObject);
        this.setFieldValByName("createDateSecond", nowDatehs, metaObject);
        this.setFieldValByName("createDateAll", LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss), metaObject);
        Object status = this.getFieldValByName("delFlag", metaObject);
        if (status == null || status.toString().equals("")) {
            this.setFieldValByName("delFlag", CrmDelFlagEnum.NORMAL.getCode(), metaObject);
        }
        if ((enableStatus = this.getFieldValByName("enableStatus", metaObject)) == null || enableStatus.toString().equals("")) {
            this.setFieldValByName("enableStatus", CrmEnableStatusEnum.ENABLE.getCode(), metaObject);
        }
        if (user != null) {
            String username = user.getUsername();
            Object createCode = metaObject.getValue("createCode");
            if (ObjectUtils.isNull((Object[])new Object[]{createCode}) && username != null && !username.trim().equals("")) {
                this.setFieldValByName("createCode", username, metaObject);
            }
            String realname = user.getRealname();
            Object createName = metaObject.getValue("createName");
            if (ObjectUtils.isNull((Object[])new Object[]{createName}) && realname != null && !realname.trim().equals("")) {
                this.setFieldValByName("createName", realname, metaObject);
            }
            String orgcode = user.getOrgcode();
            Object createOrgCode = metaObject.getValue("createOrgCode");
            if (ObjectUtils.isNull((Object[])new Object[]{createOrgCode}) && orgcode != null && !orgcode.trim().equals("")) {
                this.setFieldValByName("createOrgCode", orgcode, metaObject);
            }
            String orgname = user.getOrgname();
            Object createOrgName = metaObject.getValue("createOrgName");
            if (ObjectUtils.isNull((Object[])new Object[]{createOrgName}) && orgname != null && !orgname.trim().equals("")) {
                this.setFieldValByName("createOrgName", orgname, metaObject);
            }
            String poscode = user.getPoscode();
            Object createPosCode = metaObject.getValue("createPosCode");
            if (ObjectUtils.isNull((Object[])new Object[]{createPosCode}) && poscode != null && !poscode.trim().equals("")) {
                this.setFieldValByName("createPosCode", poscode, metaObject);
            }
            String posname = user.getPosname();
            Object createPosName = metaObject.getValue("createPosName");
            if (ObjectUtils.isNull((Object[])new Object[]{createPosName}) && posname != null && !posname.trim().equals("")) {
                this.setFieldValByName("createPosName", posname, metaObject);
            }
            if (metaObject.hasSetter("createErpCompanyCode")) {
                String wdsBusinessDivision = user.getWdsBusinessDivision();
                Object createWdsBusinessDivision = metaObject.getValue("createWdsBusinessDivision");
                if (ObjectUtils.isNull((Object[])new Object[]{createWdsBusinessDivision}) && wdsBusinessDivision != null && !wdsBusinessDivision.trim().equals("")) {
                    this.setFieldValByName("createWdsBusinessDivision", wdsBusinessDivision, metaObject);
                }
            }
            if (metaObject.hasSetter("createErpCompanyCode")) {
                String erpCompanyCode = user.getErpCompanyCode();
                Object createErpCompanyCode = metaObject.getValue("createErpCompanyCode");
                if (ObjectUtils.isNull((Object[])new Object[]{createErpCompanyCode}) && erpCompanyCode != null && !erpCompanyCode.trim().equals("")) {
                    this.setFieldValByName("createErpCompanyCode", erpCompanyCode, metaObject);
                }
            }
            if (metaObject.hasSetter("createErpCompanyName")) {
                String erpCompanyName = user.getErpCompanyName();
                Object createErpCompanyName = metaObject.getValue("createErpCompanyName");
                if (ObjectUtils.isNull((Object[])new Object[]{createErpCompanyName}) && erpCompanyName != null && !erpCompanyName.trim().equals("")) {
                    this.setFieldValByName("createErpCompanyName", erpCompanyName, metaObject);
                }
            }
        }
    }

    public void updateFill(MetaObject metaObject) {
        log.debug("\u4fee\u6539\u81ea\u52a8\u586b\u5145\u503c");
        String nowDate = DateUtil.formatDate();
        String nowDatehs = DateUtil.formatShortTime();
        UserRedis user = UserUtils.getUser();
        this.setFieldValByName("updateDate", nowDate, metaObject);
        this.setFieldValByName("updateDateSecond", nowDatehs, metaObject);
        this.setFieldValByName("updateDateAll", LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss), metaObject);
        if (user != null) {
            String posname;
            String poscode;
            String orgname;
            String orgcode;
            String realname;
            String username = user.getUsername();
            if (username != null && !username.trim().equals("")) {
                this.setFieldValByName("updateCode", username, metaObject);
            }
            if ((realname = user.getRealname()) != null && !realname.trim().equals("")) {
                this.setFieldValByName("updateName", realname, metaObject);
            }
            if ((orgcode = user.getOrgcode()) != null && !orgcode.trim().equals("")) {
                this.setFieldValByName("updateOrgCode", orgcode, metaObject);
            }
            if ((orgname = user.getOrgname()) != null && !orgname.trim().equals("")) {
                this.setFieldValByName("updateOrgName", orgname, metaObject);
            }
            if ((poscode = user.getPoscode()) != null && !poscode.trim().equals("")) {
                this.setFieldValByName("updatePosCode", poscode, metaObject);
            }
            if ((posname = user.getPosname()) != null && !posname.trim().equals("")) {
                this.setFieldValByName("updatePosName", posname, metaObject);
            }
        }
    }
}

