/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.serializers;

import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.nustaq.serialization.FSTBasicObjectSerializer;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;
import org.nustaq.serialization.util.FSTUtil;

public class FSTCollectionSerializer
extends FSTBasicObjectSerializer {
    @Override
    public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
        Collection col = (Collection)toWrite;
        int size = col.size();
        out.writeInt(size);
        Class[] possibleClasses = referencedBy.getPossibleClasses();
        if (col.getClass() == ArrayList.class) {
            List l = (List)col;
            for (int i = 0; i < size; ++i) {
                Object o = l.get(i);
                out.writeObjectInternal(o, possibleClasses);
            }
        } else {
            for (Object o : col) {
                out.writeObjectInternal(o, possibleClasses);
            }
        }
    }

    @Override
    public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPositioin) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        try {
            AbstractCollection res = null;
            int len = in.readInt();
            res = objectClass == ArrayList.class ? new ArrayList(len) : (objectClass == HashSet.class ? new HashSet(len) : (objectClass == Vector.class ? new Vector(len) : (objectClass == LinkedList.class ? new LinkedList() : objectClass.newInstance())));
            in.registerObject(res, streamPositioin, serializationInfo, referencee);
            Collection col = res;
            if (col instanceof ArrayList) {
                ((ArrayList)col).ensureCapacity(len);
            }
            Class[] possibleClasses = referencee.getPossibleClasses();
            for (int i = 0; i < len; ++i) {
                Object o = in.readObjectInternal(possibleClasses);
                col.add(o);
            }
            return res;
        }
        catch (Throwable th) {
            throw FSTUtil.rethrow(th);
        }
    }
}

