/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.serializers;

import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.nustaq.serialization.FSTBasicObjectSerializer;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;

public class FSTMapSerializer
extends FSTBasicObjectSerializer {
    @Override
    public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
        Map col = (Map)toWrite;
        out.writeInt(col.size());
        Class[] possibleClasses = referencedBy.getPossibleClasses();
        for (Map.Entry next : col.entrySet()) {
            out.writeObjectInternal(next.getKey(), possibleClasses);
            out.writeObjectInternal(next.getValue(), possibleClasses);
        }
    }

    @Override
    public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPositioin) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Map res = null;
        int len = in.readInt();
        res = objectClass == HashMap.class ? new HashMap(len) : (objectClass == Hashtable.class ? new Hashtable(len) : objectClass.newInstance());
        in.registerObject(res, streamPositioin, serializationInfo, referencee);
        Map col = res;
        Class[] possibleClasses = referencee.getPossibleClasses();
        for (int i = 0; i < len; ++i) {
            Object key = in.readObjectInternal(possibleClasses);
            Object val = in.readObjectInternal(possibleClasses);
            col.put(key, val);
        }
        return res;
    }
}

