/*
 * Decompiled with CFR 0.152.
 */
package brave.grpc;

import brave.propagation.TraceContext;
import com.google.common.base.Preconditions;
import io.grpc.Metadata;
import java.util.logging.Level;
import java.util.logging.Logger;

final class TraceContextBinaryMarshaller
implements Metadata.BinaryMarshaller<TraceContext> {
    static final Logger logger = Logger.getLogger(TraceContextBinaryMarshaller.class.getName());
    static final byte VERSION = 0;
    static final byte TRACE_ID_FIELD_ID = 0;
    static final byte SPAN_ID_FIELD_ID = 1;
    static final byte TRACE_OPTION_FIELD_ID = 2;
    private static final int FORMAT_LENGTH = 29;

    TraceContextBinaryMarshaller() {
    }

    public byte[] toBytes(TraceContext traceContext) {
        Preconditions.checkNotNull((Object)traceContext, (Object)"traceContext");
        byte[] bytes = new byte[29];
        bytes[0] = 0;
        bytes[1] = 0;
        TraceContextBinaryMarshaller.writeLong(bytes, 2, traceContext.traceIdHigh());
        TraceContextBinaryMarshaller.writeLong(bytes, 10, traceContext.traceId());
        bytes[18] = 1;
        TraceContextBinaryMarshaller.writeLong(bytes, 19, traceContext.spanId());
        bytes[27] = 2;
        if (traceContext.sampled() != null && traceContext.sampled().booleanValue()) {
            bytes[28] = 1;
        }
        return bytes;
    }

    public TraceContext parseBytes(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes == null");
        }
        if (bytes.length == 0) {
            return null;
        }
        if (bytes[0] != 0) {
            logger.log(Level.FINE, "Invalid input: unsupported version {0}", bytes[0]);
            return null;
        }
        if (bytes.length < 27) {
            logger.fine("Invalid input: truncated");
            return null;
        }
        Boolean sampled = null;
        int pos = 1;
        if (bytes[pos] != 0) {
            logger.log(Level.FINE, "Invalid input: expected trace ID at offset {0}", pos);
            return null;
        }
        long traceIdHigh = TraceContextBinaryMarshaller.readLong(bytes, ++pos);
        long traceId = TraceContextBinaryMarshaller.readLong(bytes, pos + 8);
        if (bytes[pos += 16] != 1) {
            logger.log(Level.FINE, "Invalid input: expected span ID at offset {0}", pos);
            return null;
        }
        long spanId = TraceContextBinaryMarshaller.readLong(bytes, ++pos);
        if (bytes.length > (pos += 8) && bytes[pos] == 2) {
            if (bytes.length < ++pos + 1) {
                logger.log(Level.FINE, "Invalid input: truncated");
                return null;
            }
            sampled = bytes[pos] == 1;
        }
        return TraceContext.newBuilder().traceIdHigh(traceIdHigh).traceId(traceId).spanId(spanId).sampled(sampled).build();
    }

    static void writeLong(byte[] data, int pos, long v) {
        data[pos + 0] = (byte)(v >>> 56 & 0xFFL);
        data[pos + 1] = (byte)(v >>> 48 & 0xFFL);
        data[pos + 2] = (byte)(v >>> 40 & 0xFFL);
        data[pos + 3] = (byte)(v >>> 32 & 0xFFL);
        data[pos + 4] = (byte)(v >>> 24 & 0xFFL);
        data[pos + 5] = (byte)(v >>> 16 & 0xFFL);
        data[pos + 6] = (byte)(v >>> 8 & 0xFFL);
        data[pos + 7] = (byte)(v & 0xFFL);
    }

    static long readLong(byte[] data, int pos) {
        return ((long)data[pos] & 0xFFL) << 56 | ((long)data[pos + 1] & 0xFFL) << 48 | ((long)data[pos + 2] & 0xFFL) << 40 | ((long)data[pos + 3] & 0xFFL) << 32 | ((long)data[pos + 4] & 0xFFL) << 24 | ((long)data[pos + 5] & 0xFFL) << 16 | ((long)data[pos + 6] & 0xFFL) << 8 | (long)data[pos + 7] & 0xFFL;
    }
}

