/*
 * Decompiled with CFR 0.152.
 */
package brave.grpc;

import brave.Span;
import brave.Tracer;
import brave.grpc.GrpcClientParser;
import brave.grpc.GrpcTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;

final class TracingClientInterceptor
implements ClientInterceptor {
    static final Propagation.Setter<Metadata, Metadata.Key<String>> SETTER = new Propagation.Setter<Metadata, Metadata.Key<String>>(){

        public void put(Metadata metadata, Metadata.Key<String> key, String value) {
            metadata.removeAll(key);
            metadata.put(key, (Object)value);
        }

        public String toString() {
            return "Metadata::put";
        }
    };
    final Tracer tracer;
    final TraceContext.Injector<Metadata> injector;
    final GrpcClientParser parser;

    TracingClientInterceptor(GrpcTracing grpcTracing) {
        this.tracer = grpcTracing.tracing.tracer();
        this.injector = grpcTracing.propagation.injector(SETTER);
        this.parser = grpcTracing.clientParser;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, final CallOptions callOptions, Channel next) {
        final Span span = this.tracer.nextSpan();
        try (Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);){
            ForwardingClientCall.SimpleForwardingClientCall simpleForwardingClientCall = new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    TracingClientInterceptor.this.injector.inject(span.context(), (Object)headers);
                    span.kind(Span.Kind.CLIENT).start();
                    try (Tracer.SpanInScope ws = TracingClientInterceptor.this.tracer.withSpanInScope(span);){
                        TracingClientInterceptor.this.parser.onStart(method, callOptions, headers, span.customizer());
                        super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                            public void onMessage(RespT message) {
                                try (Tracer.SpanInScope ws = TracingClientInterceptor.this.tracer.withSpanInScope(span);){
                                    TracingClientInterceptor.this.parser.onMessageReceived(message, span.customizer());
                                    this.delegate().onMessage(message);
                                }
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void onClose(Status status, Metadata trailers) {
                                try (Tracer.SpanInScope ws = TracingClientInterceptor.this.tracer.withSpanInScope(span);){
                                    super.onClose(status, trailers);
                                    TracingClientInterceptor.this.parser.onClose(status, trailers, span.customizer());
                                }
                                finally {
                                    span.finish();
                                }
                            }
                        }, headers);
                    }
                }

                public void sendMessage(ReqT message) {
                    try (Tracer.SpanInScope ws = TracingClientInterceptor.this.tracer.withSpanInScope(span);){
                        super.sendMessage(message);
                        TracingClientInterceptor.this.parser.onMessageSent(message, span.customizer());
                    }
                }
            };
            return simpleForwardingClientCall;
        }
        catch (Error | RuntimeException e) {
            span.error(e).finish();
            throw e;
        }
    }
}

