/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.api.utils;

import eleme.openapi.sdk.api.entity.other.OMessage;
import eleme.openapi.sdk.api.json.gson.Gson;
import eleme.openapi.sdk.utils.SignatureUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallbackValidationUtil {
    static Gson gson = new Gson();

    public static boolean isValidMessage(OMessage message, String secret) {
        if (message == null) {
            return false;
        }
        if (message.getSignature() == null) {
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("requestId", message.getRequestId());
        map.put("message", message.getMessage());
        map.put("type", message.getType());
        map.put("shopId", message.getShopId());
        map.put("timestamp", message.getTimestamp());
        map.put("userId", message.getUserId());
        map.put("appId", message.getAppId());
        String signature = null;
        try {
            signature = CallbackValidationUtil.getSignature(map, secret);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return signature.toUpperCase().equals(message.getSignature().toUpperCase());
    }

    public static String getSignature(Map<String, Object> params, String secret) throws IOException {
        TreeMap<String, Object> sortedParams = new TreeMap<String, Object>(params);
        Set entrys = sortedParams.entrySet();
        StringBuilder basestring = new StringBuilder();
        for (Map.Entry param : entrys) {
            basestring.append((String)param.getKey()).append("=").append(gson.toJson(param.getValue()));
        }
        basestring.append(secret);
        return SignatureUtil.md5(basestring.toString());
    }
}

