/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.coobird.thumbnailator.ThumbnailParameter;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.builders.BufferedImageBuilder;
import net.coobird.thumbnailator.builders.ThumbnailParameterBuilder;
import net.coobird.thumbnailator.filters.ImageFilter;
import net.coobird.thumbnailator.makers.FixedSizeThumbnailMaker;
import net.coobird.thumbnailator.makers.ScaledThumbnailMaker;
import net.coobird.thumbnailator.name.Rename;
import net.coobird.thumbnailator.resizers.DefaultResizerFactory;
import net.coobird.thumbnailator.resizers.Resizer;
import net.coobird.thumbnailator.tasks.ThumbnailTask;

public final class Thumbnailator {
    private Thumbnailator() {
    }

    public static void createThumbnail(ThumbnailTask<?, ?> task) throws IOException {
        BufferedImage destinationImage;
        ThumbnailParameter param = task.getParam();
        BufferedImage sourceImage = task.read();
        int imageType = param.getType();
        if (param.useOriginalImageType()) {
            int imageTypeToUse = sourceImage.getType();
            imageType = imageTypeToUse == 0 ? 2 : sourceImage.getType();
        }
        if (param.getSize() != null) {
            int destinationWidth = param.getSize().width;
            int destinationHeight = param.getSize().height;
            destinationImage = new FixedSizeThumbnailMaker().size(destinationWidth, destinationHeight).keepAspectRatio(param.isKeepAspectRatio()).fitWithinDimensions(param.fitWithinDimenions()).imageType(imageType).resizerFactory(param.getResizerFactory()).make(sourceImage);
        } else if (!Double.isNaN(param.getWidthScalingFactor())) {
            destinationImage = new ScaledThumbnailMaker().scale(param.getWidthScalingFactor(), param.getHeightScalingFactor()).imageType(imageType).resizerFactory(param.getResizerFactory()).make(sourceImage);
        } else {
            throw new IllegalStateException("Parameters to make thumbnail does not have scaling factor nor thumbnail size specified.");
        }
        for (ImageFilter filter : param.getImageFilters()) {
            destinationImage = filter.apply(destinationImage);
        }
        task.write(destinationImage);
        sourceImage.flush();
        destinationImage.flush();
    }

    public static BufferedImage createThumbnail(BufferedImage img, int width, int height) {
        Thumbnailator.validateDimensions(width, height);
        Dimension imgSize = new Dimension(img.getWidth(), img.getHeight());
        Dimension thumbnailSize = new Dimension(width, height);
        Resizer resizer = DefaultResizerFactory.getInstance().getResizer(imgSize, thumbnailSize);
        BufferedImage thumbnailImage = new FixedSizeThumbnailMaker(width, height, true, true).resizer(resizer).make(img);
        return thumbnailImage;
    }

    public static void createThumbnail(File inFile, File outFile, int width, int height) throws IOException {
        Thumbnailator.validateDimensions(width, height);
        if (inFile == null) {
            throw new NullPointerException("Input file is null.");
        }
        if (outFile == null) {
            throw new NullPointerException("Output file is null.");
        }
        if (!inFile.exists()) {
            throw new IOException("Input file does not exist.");
        }
        Thumbnails.of(inFile).size(width, height).toFile(outFile);
    }

    public static BufferedImage createThumbnail(File f, int width, int height) throws IOException {
        Thumbnailator.validateDimensions(width, height);
        if (f == null) {
            throw new NullPointerException("Input file is null.");
        }
        return Thumbnails.of(f).size(width, height).asBufferedImage();
    }

    public static Image createThumbnail(Image img, int width, int height) {
        Thumbnailator.validateDimensions(width, height);
        BufferedImage srcImg = new BufferedImageBuilder(img.getWidth(null), img.getHeight(null)).build();
        Graphics2D g = srcImg.createGraphics();
        g.drawImage(img, width, height, null);
        g.dispose();
        return Thumbnailator.createThumbnail(srcImg, width, height);
    }

    public static void createThumbnail(InputStream is, OutputStream os, int width, int height) throws IOException {
        Thumbnailator.createThumbnail(is, os, ThumbnailParameter.ORIGINAL_FORMAT, width, height);
    }

    public static void createThumbnail(InputStream is, OutputStream os, String format, int width, int height) throws IOException {
        Thumbnailator.validateDimensions(width, height);
        if (is == null) {
            throw new NullPointerException("InputStream is null.");
        }
        if (os == null) {
            throw new NullPointerException("OutputStream is null.");
        }
        Thumbnails.of(is).size(width, height).outputFormat(format).toOutputStream(os);
    }

    public static Collection<File> createThumbnailsAsCollection(Collection<? extends File> files, Rename rename, int width, int height) throws IOException {
        Thumbnailator.validateDimensions(width, height);
        if (files == null) {
            throw new NullPointerException("Collection of Files is null.");
        }
        if (rename == null) {
            throw new NullPointerException("Rename is null.");
        }
        ArrayList<File> resultFiles = new ArrayList<File>();
        ThumbnailParameter param = new ThumbnailParameterBuilder().size(width, height).build();
        for (File file : files) {
            File outFile = new File(file.getParent(), rename.apply(file.getName(), param));
            Thumbnailator.createThumbnail(file, outFile, width, height);
            resultFiles.add(outFile);
        }
        return Collections.unmodifiableList(resultFiles);
    }

    public static void createThumbnails(Collection<? extends File> files, Rename rename, int width, int height) throws IOException {
        Thumbnailator.validateDimensions(width, height);
        if (files == null) {
            throw new NullPointerException("Collection of Files is null.");
        }
        if (rename == null) {
            throw new NullPointerException("Rename is null.");
        }
        ThumbnailParameter param = new ThumbnailParameterBuilder().size(width, height).build();
        for (File file : files) {
            File outFile = new File(file.getParent(), rename.apply(file.getName(), param));
            Thumbnailator.createThumbnail(file, outFile, width, height);
        }
    }

    private static void validateDimensions(int width, int height) {
        if (width <= 0 && height <= 0) {
            throw new IllegalArgumentException("Destination image dimensions must not be less than 0 pixels.");
        }
        if (width <= 0 || height <= 0) {
            String dimension = width == 0 ? "width" : "height";
            throw new IllegalArgumentException("Destination image " + dimension + " must not be " + "less than or equal to 0 pixels.");
        }
    }
}

